/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.search.MethodSuperSearcher;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.aop.model.xml.AopConfig;
import com.intellij.spring.aop.model.xml.AspectjAutoproxy;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.tx.AnnotationDriven;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAdvisedElementsSearcher
extends AopAdvisedElementsSearcher {
    private final NotNullLazyValue<Boolean> myCglibProxyType = NotNullLazyValue.atomicLazy(() -> {
        for (LocalXmlModel localXmlModel : SpringModelVisitorUtils.getLocalXmlModels(this.getSpringModel())) {
            DomFileElement<Beans> root = localXmlModel.getRoot();
            if (root == null || !SpringAdvisedElementsSearcher.isCglib(root)) continue;
            return true;
        }
        return false;
    });
    private final Module myModule;
    private final NotNullFactory<? extends CommonSpringModel> myModelFactory;

    public SpringAdvisedElementsSearcher(@Nullable Module module, NotNullFactory<? extends CommonSpringModel> modelFactory) {
        this.myModule = module;
        this.myModelFactory = modelFactory;
    }

    private static boolean isCglib(DomFileElement<Beans> root) {
        return (Boolean)CachedValuesManager.getManager((Project)root.getManager().getProject()).getCachedValue(root, () -> CachedValueProvider.Result.create((Object)SpringAdvisedElementsSearcher.calcIsCglib(root), (Object[])new Object[]{root}));
    }

    private static boolean calcIsCglib(DomFileElement<Beans> domFileElement) {
        boolean hasAopNamespace = SpringDomUtils.hasNamespace(domFileElement, "Spring AOP namespace key");
        boolean hasTxNamespace = SpringDomUtils.hasNamespace(domFileElement, "Spring TX namespace key");
        if (!hasAopNamespace && !hasTxNamespace) {
            return false;
        }
        DomElement rootElement = domFileElement.getRootElement();
        if (hasAopNamespace && SpringDomUtils.hasElement(domFileElement, AopConfig.class)) {
            for (AopConfig config : DomUtil.getDefinedChildrenOfType((DomElement)rootElement, AopConfig.class, (boolean)true, (boolean)false)) {
                if (!Boolean.TRUE.equals(config.getProxyTargetClass().getValue())) continue;
                return true;
            }
        }
        if (!SpringDomUtils.hasElement(domFileElement, AnnotationDriven.class) && !SpringDomUtils.hasElement(domFileElement, AspectjAutoproxy.class)) {
            return false;
        }
        CommonProcessors.FindProcessor<CommonSpringBean> processor2 = new CommonProcessors.FindProcessor<CommonSpringBean>(){

            protected boolean accept(CommonSpringBean bean) {
                return bean instanceof AnnotationDriven && Boolean.TRUE.equals(((AnnotationDriven)((Object)bean)).getProxyTargetClass().getValue()) || bean instanceof AspectjAutoproxy && Boolean.TRUE.equals(((AspectjAutoproxy)bean).getProxyTargetClass().getValue());
            }
        };
        SpringBeanUtils.getInstance().processChildBeans(rootElement, false, (Processor<CommonSpringBean>)processor2);
        return processor2.isFound();
    }

    public boolean isInherentlyAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(0);
        }
        return SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass);
    }

    public boolean isAdvisableInModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(1);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return SpringModelSearchers.doesBeanExist(this.getSpringModel(), psiClass);
    }

    public static boolean isSpringAopAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(2);
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("final")) {
            return false;
        }
        if (SpringAdvisedElementsSearcher.isSpringAopClass(psiClass)) {
            return false;
        }
        return SpringAdvisedElementsSearcher.isAspectjAdvisable((PsiClass)psiClass);
    }

    public LinkedHashSet<PsiClass> collectAdvisedClasses() {
        MyBeanVisitor visitor = new MyBeanVisitor();
        Collection beans = (Collection)ReadAction.compute(() -> this.getSpringModel().getAllCommonBeans());
        for (SpringBeanPointer pointer : beans) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (!pointer.isValid()) {
                    return;
                }
                if (pointer instanceof DomSpringBeanPointer) {
                    SpringModelVisitor.visitBean(visitor, ((DomSpringBeanPointer)pointer).getSpringBean());
                } else {
                    visitor.processBeanClass(pointer.getEffectiveBeanTypes());
                }
            });
        }
        return visitor.result;
    }

    private static boolean isSpringAopClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(3);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            boolean result = !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)true, psiClass1 -> {
                @NonNls String qname = psiClass1.getQualifiedName();
                return !"org.springframework.aop.Advisor".equals(qname) && !"org.aopalliance.aop.Advice".equals(qname) && !"org.springframework.aop.framework.AopInfrastructureBean".equals(qname);
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static boolean hasInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(4);
        }
        return !JamCommonUtil.processSuperClassList((PsiClass)psiClass, new HashSet(), psiClass1 -> psiClass1.getInterfaces().length == 0);
    }

    public boolean canBeAdvised(@NotNull PsiMethod method) {
        if (method == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(5);
        }
        if (!super.canBeAdvised(method)) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("final")) {
            return false;
        }
        return !method.hasModifierProperty("private");
    }

    public boolean acceptsBoundMethodHeavy(@NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(6);
        }
        if (this.isJdkProxyType() && ((psiClass = method.getContainingClass()) == null || SpringAdvisedElementsSearcher.hasInterfaces(psiClass) && !SpringAdvisedElementsSearcher.isFromInterface(method, psiClass))) {
            return false;
        }
        return super.acceptsBoundMethodHeavy(method);
    }

    public boolean isJdkProxyType() {
        return (Boolean)this.myCglibProxyType.getValue() == false;
    }

    private static boolean isFromInterface(@NotNull PsiMethod method, PsiClass psiClass) {
        if (method == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(7);
        }
        return !new MethodSuperSearcher().execute((Object)new SuperMethodsSearch.SearchParameters(method, psiClass, true, false), signature -> {
            PsiClass aClass = signature.getMethod().getContainingClass();
            return aClass == null || !aClass.isInterface();
        });
    }

    public CommonSpringModel getSpringModel() {
        return (CommonSpringModel)this.myModelFactory.create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/aop/SpringAdvisedElementsSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInherentlyAdvisable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAdvisableInModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringAopAdvisable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringAopClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasInterfaces";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeAdvised";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsBoundMethodHeavy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isFromInterface";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyBeanVisitor
    extends SpringModelVisitor {
        private final LinkedHashSet<PsiClass> result = new LinkedHashSet();

        private MyBeanVisitor() {
        }

        @Override
        protected boolean visitBean(CommonSpringBean bean) {
            ProgressManager.checkCanceled();
            this.processBeanClass(BeanService.getInstance().getEffectiveBeanTypes(bean));
            super.visitBean(bean);
            return true;
        }

        final void processBeanClass(PsiType @NotNull [] effectiveTypes) {
            if (effectiveTypes == null) {
                MyBeanVisitor.$$$reportNull$$$0(0);
            }
            for (PsiType psiType : effectiveTypes) {
                PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
                if (psiClass == null || !SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass)) continue;
                this.result.add(psiClass);
                this.addAdvisableSupers(psiClass);
            }
        }

        private void addAdvisableSupers(PsiClass beanClass) {
            InheritanceUtil.processSupers((PsiClass)beanClass, (boolean)false, psiClass -> {
                if (SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass)) {
                    this.result.add((PsiClass)psiClass);
                }
                return true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveTypes", "com/intellij/spring/aop/SpringAdvisedElementsSearcher$MyBeanVisitor", "processBeanClass"));
        }
    }
}

