/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.util;

import com.intellij.facet.FacetTypeId;
import com.intellij.ide.IdeView;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.module.view.nodes.JavaeeFacetNodeDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.Nullable;

public class JavaeeDataContextWrapper {
    private final AnActionEvent myActionEvent;

    public JavaeeDataContextWrapper(AnActionEvent actionEvent) {
        this.myActionEvent = actionEvent;
    }

    @Nullable
    public JavaeeFacet getFacet() {
        return (JavaeeFacet)this.myActionEvent.getData(JavaeeFacetNodeDescriptor.FACET_NODE_KEY);
    }

    @Nullable
    public <F extends JavaeeFacet> F getFacet(FacetTypeId<F> type) {
        JavaeeFacet facet = this.getFacet();
        if (facet == null || !type.equals((Object)facet.getTypeId())) {
            return null;
        }
        return (F)facet;
    }

    public <F extends JavaeeFacet> boolean canCreateSomething(FacetTypeId<F> type) {
        F facet = this.getFacet(type);
        if (facet == null) {
            return false;
        }
        if (!((JavaeeFacetEx)facet).getCommonPart().isAllDescriptorsValid()) {
            return false;
        }
        PsiDirectory directory = this.getFirstDirectory();
        return directory == null || this.getPackage() != null;
    }

    @Nullable
    public PsiPackage getPackage() {
        PsiElement psiElement = (PsiElement)this.myActionEvent.getData(CommonDataKeys.PSI_ELEMENT);
        if (psiElement instanceof PsiPackage) {
            return (PsiPackage)psiElement;
        }
        if (psiElement instanceof PsiDirectory) {
            return JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement);
        }
        return null;
    }

    @Nullable
    public PsiDirectory getFirstDirectory() {
        PsiElement psiElement = (PsiElement)this.myActionEvent.getData(CommonDataKeys.PSI_ELEMENT);
        if (psiElement instanceof PsiDirectory) {
            return (PsiDirectory)psiElement;
        }
        IdeView ideView = (IdeView)this.myActionEvent.getData(LangDataKeys.IDE_VIEW);
        if (ideView == null) {
            return null;
        }
        PsiDirectory[] directories = ideView.getDirectories();
        if (directories.length != 0) {
            return directories[0];
        }
        return null;
    }

    public String getPackageName() {
        PsiPackage aPackage = this.getPackage();
        return aPackage == null ? "" : aPackage.getQualifiedName();
    }
}

