/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.util;

import com.intellij.javaee.util.IDeployStateChecker;
import com.intellij.javaee.util.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractServerInstancePoller<K, C extends IDeployStateChecker<K>> {
    private static final long POLL_INTERVAL = 500L;
    private DeployStatePoller myDeployStatePoller;

    protected abstract ILogger getLogger();

    protected abstract void runThread(Runnable var1);

    public void onInstanceStart() {
        this.setPoller(new DeployStatePoller());
        this.runThread(this.myDeployStatePoller);
    }

    public void onInstanceShutdown() {
        this.setPoller(null);
    }

    private void setPoller(DeployStatePoller poller) {
        DeployStatePoller oldPoller = this.myDeployStatePoller;
        this.myDeployStatePoller = poller;
        if (oldPoller != null) {
            oldPoller.shutdown();
        }
    }

    public void putDeployStateChecker(C checker) {
        if (this.myDeployStatePoller == null) {
            return;
        }
        this.myDeployStatePoller.putChecker(checker);
    }

    public void removeDeployStateChecker(K deploymentKey) {
        if (this.myDeployStatePoller == null) {
            return;
        }
        this.myDeployStatePoller.removeChecker(deploymentKey);
    }

    private class DeployStatePoller
    implements Runnable {
        private final Object myLock = new Object();
        private final Map<K, C> myDeploymentKey2StateChecker = new HashMap();
        private boolean myRunning = true;

        private DeployStatePoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putChecker(C checker) {
            Object object = this.myLock;
            synchronized (object) {
                this.myDeploymentKey2StateChecker.put(checker.getDeploymentModel(), checker);
                this.myLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChecker(K deploymentKey) {
            Object object = this.myLock;
            synchronized (object) {
                this.myDeploymentKey2StateChecker.remove(deploymentKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    ArrayList checkers;
                    Object object = this.myLock;
                    synchronized (object) {
                        checkers = new ArrayList(this.myDeploymentKey2StateChecker.values());
                    }
                    ArrayList<IDeployStateChecker> checked = new ArrayList<IDeployStateChecker>();
                    for (IDeployStateChecker checker : checkers) {
                        if (!checker.check()) continue;
                        checked.add(checker);
                    }
                    Object object2 = this.myLock;
                    synchronized (object2) {
                        this.myDeploymentKey2StateChecker.values().removeAll(checked);
                        if (this.myDeploymentKey2StateChecker.isEmpty()) {
                            this.myLock.wait();
                        } else {
                            this.myLock.wait(500L);
                        }
                    }
                } while (this.myRunning);
            }
            catch (InterruptedException e) {
                AbstractServerInstancePoller.this.getLogger().debugEx(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.myRunning = false;
            Object object = this.myLock;
            synchronized (object) {
                this.myLock.notifyAll();
            }
        }
    }
}

