/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.ui.packaging.LibrariesAndModulesCollector;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactProblemQuickFix;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeArtifactDependenciesChecker {
    protected final ArtifactType myArtifactType;
    private final ArtifactProblemsHolder myManager;
    protected final PackagingElementResolvingContext myContext;

    public JavaeeArtifactDependenciesChecker(ArtifactProblemsHolder manager, ArtifactType artifactType) {
        this.myContext = manager.getContext();
        this.myManager = manager;
        this.myArtifactType = artifactType;
    }

    protected void checkDependencies(LibrariesAndModulesCollector[] collectors, final CompositePackagingElement<?> elementWithManifest, Map<VirtualFile, String> jarsToRelativePaths, PackagingElementPath pathToElement, LibrariesAndModulesCollector ... availableElementsCollectors) {
        final Artifact artifact = pathToElement.findLastArtifact(this.myContext);
        HashSet<Module> checkedModules = new HashSet<Module>();
        LibrariesAndModulesCollector[] allCollectors = (LibrariesAndModulesCollector[])ArrayUtil.mergeArrays((Object[])collectors, (Object[])availableElementsCollectors);
        for (LibrariesAndModulesCollector collector : collectors) {
            for (Pair<Module, List<PackagingElement<?>>> pair : collector.getUsedModules()) {
                Module module = (Module)pair.getFirst();
                if (!checkedModules.add(module) || !JavaeeArtifactDependenciesChecker.shouldProcessRecursively(module)) continue;
                ModuleRootModel rootModel = this.myContext.getModulesProvider().getRootModel(module);
                ArrayList<MissingElementInArtifactProblem> problems = new ArrayList<MissingElementInArtifactProblem>();
                rootModel.orderEntries().productionOnly().runtimeOnly().forEach(entry -> {
                    if (entry instanceof LibraryOrderEntry) {
                        LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entry;
                        Library library = libraryEntry.getLibrary();
                        if (library == null || !this.isSuitableForModule(library, module) || JavaeeArtifactDependenciesChecker.containsLibrary(allCollectors, library) || JavaeeArtifactTypeBase.isStandardJavaeeLibrary(library)) {
                            return true;
                        }
                        List<VirtualFile> missingRoots = JavaeeArtifactDependenciesChecker.getMissingRoots(allCollectors, library.getFiles(OrderRootType.CLASSES));
                        if (!missingRoots.isEmpty()) {
                            final ArrayList<String> classpath = new ArrayList<String>();
                            boolean allJarsFound = true;
                            for (VirtualFile missingRoot : missingRoots) {
                                String path = (String)jarsToRelativePaths.get(missingRoot);
                                if (path != null) {
                                    classpath.add(path);
                                    continue;
                                }
                                allJarsFound = false;
                            }
                            if (allJarsFound) {
                                String jars = StringUtil.first((String)StringUtil.join(classpath, (String)", "), (int)50, (boolean)true);
                                String message = J2EEBundle.message((String)"dependency.missing.from.the.classpath", (Object[])new Object[]{jars, classpath.size(), elementWithManifest.getName()});
                                ArtifactProblemQuickFix fix = new ArtifactProblemQuickFix(J2EEBundle.message((String)"label.add.jars.to.classpath", (Object[])new Object[0])){

                                    public void performFix(ArtifactEditorContext artifactEditorContext) {
                                        ArtifactEditor editor = artifact != null ? artifactEditorContext.getOrCreateEditor(artifact) : artifactEditorContext.getThisArtifactEditor();
                                        editor.addToClasspath(elementWithManifest, classpath);
                                    }
                                };
                                this.myManager.registerWarning(message, "jars-missing-from-classpath", (List)pair.getSecond(), new ArtifactProblemQuickFix[]{fix});
                            } else {
                                String message = J2EEBundle.message((String)"library.0.required.for.module.1.is.missing.from.the.artifact", (Object[])new Object[]{library.getPresentableName(), module.getName()});
                                problems.add(new MissingLibraryInArtifactProblem(module, library, message, libraryEntry, (List)pair.getSecond()));
                            }
                        }
                    } else if (entry instanceof ModuleOrderEntry) {
                        ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)entry;
                        Module dependency = moduleOrderEntry.getModule();
                        if (dependency == null || !(ModuleType.get((Module)dependency) instanceof JavaModuleType)) {
                            return true;
                        }
                        if (!JavaeeArtifactDependenciesChecker.containsModule(allCollectors, dependency)) {
                            String errorMessage = J2EEBundle.message((String)"module.0.required.for.module.1.is.missing.from.the.artifact", (Object[])new Object[]{dependency.getName(), module.getName()});
                            problems.add(new MissingModuleInArtifactProblem(module, dependency, errorMessage, moduleOrderEntry, (List)pair.getSecond()));
                        }
                    }
                    return true;
                });
                AddAllDependenciesQuickFix addAllDependenciesFix = null;
                if (problems.size() > 1) {
                    addAllDependenciesFix = new AddAllDependenciesQuickFix(problems, module);
                }
                for (MissingElementInArtifactProblem problem : problems) {
                    problem.registerWarning(this.myManager, addAllDependenciesFix);
                }
            }
        }
    }

    private static boolean shouldProcessRecursively(Module module) {
        for (OrderEnumerationHandler.Factory factory : (OrderEnumerationHandler.Factory[])OrderEnumerationHandler.EP_NAME.getExtensions()) {
            if (!factory.isApplicable(module) || factory.createHandler(module).shouldProcessDependenciesRecursively()) continue;
            return false;
        }
        return true;
    }

    private boolean isSuitableForModule(@NotNull Library library, @NotNull Module module) {
        PersistentLibraryKind kind;
        if (library == null) {
            JavaeeArtifactDependenciesChecker.$$$reportNull$$$0(0);
        }
        if (module == null) {
            JavaeeArtifactDependenciesChecker.$$$reportNull$$$0(1);
        }
        if ((kind = ((LibraryEx)library).getKind()) == null) {
            return true;
        }
        return LibraryType.findByKind((LibraryKind)kind).isSuitableModule(module, this.myContext.getFacetsProvider());
    }

    @NotNull
    private static ArtifactProblemQuickFix createSetDependencyScopeFix(final Module module, final OrderEntry entry, final DependencyScope scope) {
        return new ArtifactProblemQuickFix(J2EEBundle.message((String)"artifact.dependencies.checker.label.change.scope.to", (Object[])new Object[]{entry.getPresentableName(), scope.toString()})){

            public void performFix(ArtifactEditorContext artifactEditorContext) {
                ModifiableRootModel model = artifactEditorContext.getOrCreateModifiableRootModel(module);
                for (OrderEntry orderEntry : model.getOrderEntries()) {
                    if (orderEntry.compareTo((Object)entry) != 0) continue;
                    ((ExportableOrderEntry)orderEntry).setScope(scope);
                    break;
                }
            }
        };
    }

    private static boolean containsModule(LibrariesAndModulesCollector[] collectors, Module module) {
        for (LibrariesAndModulesCollector collector : collectors) {
            for (Pair<Module, List<PackagingElement<?>>> pair : collector.getUsedModules()) {
                if (!((Module)pair.getFirst()).equals(module)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsLibrary(LibrariesAndModulesCollector[] collectors, Library library) {
        for (LibrariesAndModulesCollector collector : collectors) {
            if (!collector.getIncludedLibraries().contains(library)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsLibraryFile(LibrariesAndModulesCollector[] collectors, VirtualFile file) {
        for (LibrariesAndModulesCollector collector : collectors) {
            if (!collector.getIncludedLibraryFiles().contains(file)) continue;
            return true;
        }
        return false;
    }

    private static List<VirtualFile> getMissingRoots(LibrariesAndModulesCollector[] collectors, VirtualFile[] roots) {
        SmartList missingRoots = new SmartList();
        for (VirtualFile file : roots) {
            if (JavaeeArtifactDependenciesChecker.containsLibraryFile(collectors, file)) continue;
            missingRoots.add(file);
        }
        return missingRoots;
    }

    public void processWebApplication(CompositePackagingElement<?> warRoot, PackagingElementPath pathToWar, Map<VirtualFile, String> jarsToRelativePaths, LibrariesAndModulesCollector ... availableElementsCollectors) {
        LibrariesAndModulesCollector classesCollector = new LibrariesAndModulesCollector(this.myContext, this.myArtifactType, false);
        ArtifactUtil.processDirectoryChildren(warRoot, (PackagingElementPath)pathToWar, (String)"WEB-INF/classes", (PackagingElementResolvingContext)this.myContext, (ArtifactType)this.myArtifactType, (PackagingElementProcessor)classesCollector);
        LibrariesAndModulesCollector jarsCollector = new LibrariesAndModulesCollector(this.myContext, this.myArtifactType, true);
        ArtifactUtil.processDirectoryChildren(warRoot, (PackagingElementPath)pathToWar, (String)"WEB-INF/lib", (PackagingElementResolvingContext)this.myContext, (ArtifactType)this.myArtifactType, (PackagingElementProcessor)jarsCollector);
        this.checkDependencies(new LibrariesAndModulesCollector[]{classesCollector, jarsCollector}, warRoot, jarsToRelativePaths, pathToWar, availableElementsCollectors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "library";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/ui/packaging/JavaeeArtifactDependenciesChecker";
        objectArray[2] = "isSuitableForModule";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddAllDependenciesQuickFix
    extends ArtifactProblemQuickFix {
        private final List<MissingElementInArtifactProblem> myProblems;

        AddAllDependenciesQuickFix(List<MissingElementInArtifactProblem> problems, Module module) {
            super(J2EEBundle.message((String)"artifact.dependency.checker.add.all.dependencies.fix.name", (Object[])new Object[]{module.getName()}));
            this.myProblems = problems;
        }

        public void performFix(ArtifactEditorContext artifactEditorContext) {
            for (MissingElementInArtifactProblem problem : this.myProblems) {
                ArtifactProblemQuickFix fix = problem.getIncludeRecursivelyFix();
                if (fix != null) {
                    fix.performFix(artifactEditorContext);
                    continue;
                }
                problem.performFix(artifactEditorContext);
            }
        }
    }

    private static class MissingLibraryInArtifactProblem
    extends MissingElementInArtifactProblem {
        private final Library myLibrary;

        MissingLibraryInArtifactProblem(Module module, Library library, @Nls(capitalization=Nls.Capitalization.Sentence) String message, LibraryOrderEntry libraryEntry, List<PackagingElement<?>> moduleElementPath) {
            super(J2EEBundle.message((String)"missing.module.in.artifact.label.add.to.artifact", (Object[])new Object[]{library.getPresentableName()}), "library-missing-from-artifact", (ExportableOrderEntry)libraryEntry, module, moduleElementPath, message);
            this.myLibrary = library;
        }

        public void performFix(ArtifactEditorContext artifactEditorContext) {
            artifactEditorContext.getThisArtifactEditor().putLibraryIntoDefaultLocation(this.myLibrary);
        }
    }

    private static class AddModuleDependenciesRecursivelyQuickFix
    extends ArtifactProblemQuickFix {
        private final Module myModule;

        AddModuleDependenciesRecursivelyQuickFix(Module module) {
            super(J2EEBundle.message((String)"artifact.dependency.checker.add.dependencies.recursively.fix.name", (Object[])new Object[]{module.getName()}));
            this.myModule = module;
        }

        public void performFix(ArtifactEditorContext artifactEditorContext) {
            OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)this.myModule).using((RootModelProvider)artifactEditorContext.getModulesProvider()).productionOnly().runtimeOnly().withoutSdk().recursively();
            enumerator.forEachModule(module -> {
                artifactEditorContext.getThisArtifactEditor().putModuleIntoDefaultLocation(module);
                return true;
            });
            enumerator.forEachLibrary(library -> {
                artifactEditorContext.getThisArtifactEditor().putLibraryIntoDefaultLocation(library);
                return true;
            });
        }
    }

    private static class MissingModuleInArtifactProblem
    extends MissingElementInArtifactProblem {
        private final Module myDependency;

        MissingModuleInArtifactProblem(Module module, Module dependency, @Nls(capitalization=Nls.Capitalization.Sentence) String errorMessage, ModuleOrderEntry moduleOrderEntry, List<PackagingElement<?>> moduleElementPath) {
            super(J2EEBundle.message((String)"missing.module.in.artifact.label.add.to.artifact", (Object[])new Object[]{dependency.getName()}), "module-missing-from-artifact", (ExportableOrderEntry)moduleOrderEntry, module, moduleElementPath, errorMessage);
            this.myDependency = dependency;
        }

        public void performFix(ArtifactEditorContext artifactEditorContext) {
            artifactEditorContext.getThisArtifactEditor().putModuleIntoDefaultLocation(this.myDependency);
        }

        @Override
        @Nullable
        public ArtifactProblemQuickFix getIncludeRecursivelyFix() {
            return new AddModuleDependenciesRecursivelyQuickFix(this.myDependency);
        }
    }

    private static abstract class MissingElementInArtifactProblem
    extends ArtifactProblemQuickFix {
        private final String myProblemTypeId;
        private final ExportableOrderEntry myOrderEntry;
        private final Module myModule;
        private final List<PackagingElement<?>> myModuleElementPath;
        @Nls(capitalization=Nls.Capitalization.Sentence)
        private final String myErrorMessage;

        private MissingElementInArtifactProblem(@NlsContexts.Label String actionName, String problemTypeId, ExportableOrderEntry orderEntry, Module module, List<PackagingElement<?>> moduleElementPath, @Nls(capitalization=Nls.Capitalization.Sentence) String errorMessage) {
            super(actionName);
            this.myProblemTypeId = problemTypeId;
            this.myOrderEntry = orderEntry;
            this.myModule = module;
            this.myModuleElementPath = moduleElementPath;
            this.myErrorMessage = errorMessage;
        }

        public void registerWarning(@NotNull ArtifactProblemsHolder problemsHolder, @Nullable ArtifactProblemQuickFix addAllFix) {
            if (problemsHolder == null) {
                MissingElementInArtifactProblem.$$$reportNull$$$0(0);
            }
            Object[] scopeFixes = new ArtifactProblemQuickFix[]{JavaeeArtifactDependenciesChecker.createSetDependencyScopeFix(this.myModule, (OrderEntry)this.myOrderEntry, DependencyScope.TEST), JavaeeArtifactDependenciesChecker.createSetDependencyScopeFix(this.myModule, (OrderEntry)this.myOrderEntry, DependencyScope.PROVIDED)};
            List includeFixes = ContainerUtil.packNullables((Object[])new ArtifactProblemQuickFix[]{this, this.getIncludeRecursivelyFix(), addAllFix});
            ArtifactProblemQuickFix[] fixes = (ArtifactProblemQuickFix[])ArrayUtil.mergeArrays((Object[])includeFixes.toArray(new ArtifactProblemQuickFix[0]), (Object[])scopeFixes);
            problemsHolder.registerWarning(this.myErrorMessage, this.myProblemTypeId, this.myModuleElementPath, fixes);
        }

        @Nullable
        public ArtifactProblemQuickFix getIncludeRecursivelyFix() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/javaee/ui/packaging/JavaeeArtifactDependenciesChecker$MissingElementInArtifactProblem", "registerWarning"));
        }
    }
}

