/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.ide.util.PackageUtil;
import com.intellij.javaee.J2EEBundle;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DestinationChooserDialog
extends DialogWrapper {
    private static final String PACKAGE_RECENTS_KEY = "DestinationChooserDialog.Package.RECENTS_KEY";
    private final Project myProject;
    private ModulesComboBox myModulesChooser;
    private ReferenceEditorComboWithBrowseButton myPackageEditor;
    private JBCheckBox myOverrideFilesCheckBox;

    public DestinationChooserDialog(@Nullable Project project, @Nls String title) {
        super(project);
        this.myProject = project;
        this.setTitle(title);
        this.init();
    }

    protected void init() {
        super.init();
        this.myPackageEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiPackage aPackage;
                PackageChooserDialog chooser = new PackageChooserDialog(J2EEBundle.message((String)"dialog.title.choose.package", (Object[])new Object[0]), DestinationChooserDialog.this.getSelectedModule());
                chooser.selectPackage(DestinationChooserDialog.this.myPackageEditor.getText());
                if (chooser.showAndGet() && (aPackage = chooser.getSelectedPackage()) != null) {
                    DestinationChooserDialog.this.myPackageEditor.setText(aPackage.getQualifiedName());
                }
            }
        });
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myModulesChooser = new ModulesComboBox();
        this.myModulesChooser.fillModules(this.myProject);
        Collection modules = ModuleUtil.getModulesOfType((Project)this.myProject, (ModuleType)JavaModuleType.getModuleType());
        if (!modules.isEmpty()) {
            this.myModulesChooser.setSelectedModule((Module)modules.iterator().next());
        }
        this.myPackageEditor = new ReferenceEditorComboWithBrowseButton(null, "", this.myProject, false, PACKAGE_RECENTS_KEY);
        FormBuilder builder = FormBuilder.createFormBuilder();
        if (JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)this.myProject).size() > 1) {
            builder.addLabeledComponent((JComponent)new JLabel(J2EEBundle.message((String)"DestinationChooserDialog.target.module", (Object[])new Object[0])), (JComponent)this.myModulesChooser);
        }
        this.myOverrideFilesCheckBox = new JBCheckBox();
        return builder.addLabeledComponent((JComponent)new JLabel(J2EEBundle.message((String)"DestinationChooserDialog.target.package", (Object[])new Object[0])), (JComponent)this.myPackageEditor).addLabeledComponent((JComponent)new JLabel(J2EEBundle.message((String)"DestinationChooserDialog.override.existing.files", (Object[])new Object[0])), (JComponent)this.myOverrideFilesCheckBox).getPanel();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.getSelectedModule() == null) {
            return new ValidationInfo(J2EEBundle.message((String)"DestinationChooserDialog.module.not.specified", (Object[])new Object[0]));
        }
        if (this.getSelectedPackage() == null) {
            return new ValidationInfo(J2EEBundle.message((String)"DestinationChooserDialog.package.not.specified", (Object[])new Object[0]));
        }
        return null;
    }

    protected void doOKAction() {
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(PACKAGE_RECENTS_KEY, this.getSelectedPackage());
        super.doOKAction();
    }

    private Module getSelectedModule() {
        return this.myModulesChooser.getSelectedModule();
    }

    public String getSelectedPackage() {
        return this.myPackageEditor.getText();
    }

    public File guessDirectory() {
        PsiDirectory possibleDirectory = PackageUtil.findPossiblePackageDirectoryInModule((Module)this.getSelectedModule(), (String)this.getSelectedPackage());
        if (possibleDirectory == null) {
            return null;
        }
        return VfsUtilCore.virtualToIoFile((VirtualFile)possibleDirectory.getVirtualFile());
    }

    public boolean getOverrideExistingFiles() {
        return this.myOverrideFilesCheckBox.isSelected();
    }
}

