/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.toolwindow.view;

import com.intellij.ProjectTopics;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.toolwindow.view.JavaeeViewFrameworkProvider;
import com.intellij.javaee.toolwindow.view.JavaeeViewSettings;
import com.intellij.javaee.toolwindow.view.panels.FrameworksFinderRecursivePanel;
import com.intellij.javaee.toolwindow.view.panels.ModulesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JavaeeView
extends SimpleToolWindowPanel
implements Disposable {
    private final Project myProject;
    private FinderRecursivePanel<?> myContent;
    private final DefaultActionGroup myActions = new DefaultActionGroup();

    public JavaeeView(Project project) {
        super(false, true);
        this.myProject = project;
        DumbService.getInstance((Project)project).runWhenSmart(() -> {
            this.installToolbar();
            this.installGlobalListeners();
            this.installSettingsListener();
            this.installProjectListeners();
            this.refreshContentPanel();
        });
    }

    private void installGlobalListeners() {
        JavaeeViewFrameworkProvider.EXTENSION_POINT_NAME.addChangeListener(() -> {
            this.removeContent();
            ApplicationManager.getApplication().invokeLater(() -> this.refreshContentPanel(), ModalityState.NON_MODAL, this.myProject.getDisposed());
        }, (Disposable)this);
    }

    private void installToolbar() {
        final JavaeeViewSettings settings = JavaeeViewSettings.getInstance(this.myProject);
        DefaultActionGroup frameworkViewGroup = new DefaultActionGroup();
        frameworkViewGroup.add((AnAction)new ToggleAction(J2EEBundle.message((String)"JavaeeView.technologies.frameworks.view", (Object[])new Object[0]), null, AllIcons.Actions.GroupByModule){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return settings.isFrameworksView();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                settings.setFrameworksView(state);
                settings.fireSettingsChanged(JavaeeViewSettings.ChangeType.FULL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/javaee/toolwindow/view/JavaeeView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DefaultActionGroup showModulesGroup = new DefaultActionGroup();
        showModulesGroup.add((AnAction)new ToggleAction(J2EEBundle.message((String)"JavaeeView.action.show.modules", (Object[])new Object[0]), null, AllIcons.Nodes.Project){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return settings.isShowModules();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                settings.setShowModules(state);
                settings.fireSettingsChanged(JavaeeViewSettings.ChangeType.FORCE_UPDATE);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(2);
                }
                super.update(e);
                e.getPresentation().setEnabled(JavaeeViewSettings.getInstance(JavaeeView.this.myProject).isFrameworksView());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/javaee/toolwindow/view/JavaeeView$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myActions.add((AnAction)frameworkViewGroup);
        this.myActions.add((AnAction)showModulesGroup);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("JEEView", (ActionGroup)this.myActions, false);
        toolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(toolbar.getComponent());
    }

    private void installSettingsListener() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(JavaeeViewSettings.TOPIC, changeType -> {
            if (changeType == JavaeeViewSettings.ChangeType.FULL) {
                this.doFullChange();
            } else if (changeType == JavaeeViewSettings.ChangeType.FORCE_UPDATE) {
                this.myContent.updateRightComponent(true);
            } else if (changeType == JavaeeViewSettings.ChangeType.UPDATE) {
                this.myContent.updatePanel();
            }
        });
    }

    private void installProjectListeners() {
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect();
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                JavaeeView.this.doFullChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javaee/toolwindow/view/JavaeeView$3", "rootsChanged"));
            }
        });
        messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    4.$$$reportNull$$$0(1);
                }
                JavaeeView.this.doFullChange();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    4.$$$reportNull$$$0(3);
                }
                JavaeeView.this.doFullChange();
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
                if (project == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (modules == null) {
                    4.$$$reportNull$$$0(5);
                }
                if (oldNameProvider == null) {
                    4.$$$reportNull$$$0(6);
                }
                JavaeeView.this.doFullChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/toolwindow/view/JavaeeView$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBusConnection.subscribe(PsiModificationTracker.TOPIC, () -> {
            if (this.myContent == null) {
                this.refreshContentPanel();
            } else {
                this.myContent.updateRightComponent(false);
            }
        });
    }

    private void doFullChange() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            this.removeContent();
            this.refreshContentPanel();
        }, ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    private void removeContent() {
        FinderRecursivePanel<?> oldPanel = this.myContent;
        this.remove((Component)oldPanel);
        Disposer.dispose(oldPanel);
    }

    private void refreshContentPanel() {
        this.myContent = JavaeeViewSettings.getInstance(this.myProject).isFrameworksView() ? new FrameworksFinderRecursivePanel(this.myProject, this.myActions) : new ModulesPanel(this.myProject, this.myActions);
        this.myContent.initPanel();
        this.setContent((JComponent)this.myContent);
        Disposer.register((Disposable)this, this.myContent);
    }

    public void dispose() {
    }
}

