/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process.common;

import com.intellij.util.Base64;
import java.io.UnsupportedEncodingException;

public final class Base64EncodingUtil {
    public static final String UTF8 = "UTF8";
    private static final String NULL_TEXT = "_null_";

    public static String encodeBase64(String text) {
        if (text == null) {
            return NULL_TEXT;
        }
        try {
            return Base64.encode((byte[])text.getBytes(UTF8));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeBase64(String encodedText) {
        if (NULL_TEXT.equals(encodedText)) {
            return null;
        }
        try {
            return new String(Base64.decode((String)encodedText), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private Base64EncodingUtil() {
    }
}

