/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributionModel;
import com.intellij.javaee.ui.packaging.ExplodedEarArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedEjbArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeFrameworkSupportContributionModelImpl
implements JavaeeFrameworkSupportContributionModel {
    private ModifiableArtifactModel myModifiableArtifactModel;
    private final JavaeeFrameworkSupportInfoCollector myCollector;
    private final FrameworkSupportModel myFrameworkSupportModel;
    private final Module myModule;
    private final ModifiableRootModel myRootModel;

    public JavaeeFrameworkSupportContributionModelImpl(FrameworkSupportModel model, Module module, ModifiableRootModel rootModel, JavaeeFrameworkSupportInfoCollector collector) {
        this.myFrameworkSupportModel = model;
        this.myModule = module;
        this.myRootModel = rootModel;
        this.myCollector = collector;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myModule.getProject();
        if (project == null) {
            JavaeeFrameworkSupportContributionModelImpl.$$$reportNull$$$0(0);
        }
        return project;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            JavaeeFrameworkSupportContributionModelImpl.$$$reportNull$$$0(1);
        }
        return module;
    }

    @NotNull
    public ModifiableRootModel getRootModel() {
        ModifiableRootModel modifiableRootModel = this.myRootModel;
        if (modifiableRootModel == null) {
            JavaeeFrameworkSupportContributionModelImpl.$$$reportNull$$$0(2);
        }
        return modifiableRootModel;
    }

    public ModifiableArtifact getModifiableExplodedWarArtifact() {
        return this.getModifiableArtifact(this.getExplodedWarArtifact());
    }

    public ModifiableArtifact getModifiableExplodedEjbArtifact() {
        return this.getModifiableArtifact(this.getExplodedEjbArtifact());
    }

    public ModifiableArtifact getModifiableExplodedEarArtifact() {
        return this.getModifiableArtifact(this.getExplodedEarArtifact());
    }

    public Artifact getExplodedWarArtifact() {
        return this.myCollector.getArtifact((ArtifactType)ExplodedWarArtifactType.getInstance());
    }

    public Artifact getExplodedEarArtifact() {
        return this.myCollector.getArtifact((ArtifactType)ExplodedEarArtifactType.getInstance());
    }

    public Artifact getExplodedEjbArtifact() {
        return this.myCollector.getArtifact((ArtifactType)ExplodedEjbArtifactType.getInstance());
    }

    public CommonModel getRunConfiguration() {
        return this.myCollector.getRunConfiguration();
    }

    @Nullable
    private ModifiableArtifact getModifiableArtifact(Artifact artifact) {
        return artifact != null ? this.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(artifact) : null;
    }

    private ModifiableArtifactModel getOrCreateModifiableArtifactModel() {
        if (this.myModifiableArtifactModel == null) {
            this.myModifiableArtifactModel = ArtifactManager.getInstance((Project)this.getProject()).createModifiableModel();
        }
        return this.myModifiableArtifactModel;
    }

    @Nullable
    public <F extends Facet> F getFacet(FacetTypeId<F> id) {
        return (F)this.myCollector.getFacet(id);
    }

    public VirtualFile getIndexJspFile() {
        return this.myCollector.getIndexJspFile();
    }

    public boolean isFrameworkSelected(@NotNull @NonNls String providerId) {
        if (providerId == null) {
            JavaeeFrameworkSupportContributionModelImpl.$$$reportNull$$$0(3);
        }
        return this.myFrameworkSupportModel.isFrameworkSelected(providerId);
    }

    public boolean isFacetFrameworkSelected(@NotNull @NonNls FacetTypeId<?> typeId) {
        if (typeId == null) {
            JavaeeFrameworkSupportContributionModelImpl.$$$reportNull$$$0(4);
        }
        return this.myFrameworkSupportModel.isFrameworkSelected(FacetBasedFrameworkSupportProvider.getProviderId(typeId));
    }

    public void commitModels() {
        if (this.myModifiableArtifactModel != null) {
            if (this.myModifiableArtifactModel.isModified()) {
                this.myModifiableArtifactModel.commit();
            } else {
                this.myModifiableArtifactModel.dispose();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/facet/JavaeeFrameworkSupportContributionModelImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/facet/JavaeeFrameworkSupportContributionModelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFacetFrameworkSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

