/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.application.model.xml.application.JavaeeApplication;
import com.intellij.javaee.ejb.model.xml.EjbJar;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.SecurityRole;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;

public final class SecurityRoleNameInspection
extends BasicDomElementsInspection<JavaeeDomModelElement> {
    private static final ElementPattern<Character> ROLE_NAME_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{CharPattern.javaIdentifierPartCharacter(), StandardPatterns.character().oneOf((Object[])new Character[]{Character.valueOf('.'), Character.valueOf('-')})});

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        String text;
        SecurityRole securityRole;
        GenericDomValue nameValue;
        XmlTag tag;
        if (element instanceof SecurityRole && (tag = (nameValue = (securityRole = (SecurityRole)element).getRoleName()).getXmlTag()) != null && (text = nameValue.getStringValue()) != null) {
            for (int i = 0; i < text.length(); ++i) {
                if (ROLE_NAME_PATTERN.accepts((Object)Character.valueOf(text.charAt(i)))) continue;
                holder.createProblem((DomElement)nameValue, HighlightSeverity.ERROR, J2EEBundle.message((String)"security.role.name.should.accord.to.nmtoken.pattern", (Object[])new Object[0]));
                return;
            }
        }
    }

    public SecurityRoleNameInspection() {
        super(JavaeeApplication.class, new Class[]{EjbJar.class, WebApp.class});
    }
}

