/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelRefactoringSupport;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeFieldRefactoringSupport<T extends CommonModelElement>
extends CommonModelRefactoringSupport<T, PsiMember> {
    private final Class<T> myFieldClass;

    public JavaeeFieldRefactoringSupport(Class<T> fieldClass) {
        super(PsiMember.class);
        this.myFieldClass = fieldClass;
    }

    protected FindUsagesHandler createFindUsagesHandler(@NotNull T field, @NotNull PsiElement originalElement) {
        if (field == null) {
            JavaeeFieldRefactoringSupport.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            JavaeeFieldRefactoringSupport.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = Objects.requireNonNull(field.getIdentifyingPsiElement());
        return new FindUsagesHandler(psiElement, (CommonModelElement)field, originalElement){
            final /* synthetic */ CommonModelElement val$field;
            final /* synthetic */ PsiElement val$originalElement;
            {
                this.val$field = commonModelElement;
                this.val$originalElement = psiElement;
                super(arg0);
            }

            public PsiElement @NotNull [] getSecondaryElements() {
                PsiElement[] psiElementArray;
                if (this.checkAccessors()) {
                    psiElementArray = PsiUtilCore.toPsiElementArray((Collection)JavaeeFieldRefactoringSupport.this.getAccessors(this.val$field));
                } else {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = this.val$originalElement;
                }
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            private boolean checkAccessors() {
                boolean isModelNavigationElement;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return true;
                }
                boolean bl = isModelNavigationElement = !ModelMergerUtil.createFilteringProcessor(o -> o.getNavigationElement() != this.val$originalElement).process((Object)this.val$field.getIdentifyingPsiElement());
                if (this.val$originalElement instanceof PsiField || this.val$originalElement instanceof PsiMethod && !isModelNavigationElement && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)this.val$originalElement))) {
                    return this.isSearchForAccessors();
                }
                return true;
            }

            private boolean isSearchForAccessors() {
                FindUsagesOptions options = this.getFindUsagesOptions();
                return options instanceof JavaVariableFindUsagesOptions && ((JavaVariableFindUsagesOptions)options).isSearchForAccessors;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/JavaeeFieldRefactoringSupport$1", "getSecondaryElements"));
            }
        };
    }

    public T getModelElementFromMetaData(PsiElement psiElement) {
        if (psiElement instanceof XmlTag) {
            XmlTag tag = (XmlTag)psiElement;
            DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            return (T)((CommonModelElement)ObjectUtils.tryCast((Object)domElement, this.myFieldClass));
        }
        if (psiElement instanceof PsiMember) {
            PsiMember member = (PsiMember)psiElement;
            if (!this.acceptPsiMember(member)) {
                return null;
            }
            for (PersistentAttribute attribute : PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member)) {
                if (!this.myFieldClass.isInstance(attribute)) continue;
                return (T)((CommonModelElement)this.myFieldClass.cast(attribute));
            }
            return null;
        }
        Object modelObject = JamCommonUtil.getModelObject((PsiElement)psiElement);
        return (T)((CommonModelElement)ObjectUtils.tryCast((Object)modelObject, this.myFieldClass));
    }

    protected boolean acceptPsiMember(@NotNull PsiMember member) {
        if (member == null) {
            JavaeeFieldRefactoringSupport.$$$reportNull$$$0(2);
        }
        return true;
    }

    boolean askUserIfAccessorsShouldBeTakenIntoAccount(@NotNull T field, @NotNull PsiElement originalElement) {
        if (field == null) {
            JavaeeFieldRefactoringSupport.$$$reportNull$$$0(3);
        }
        if (originalElement == null) {
            JavaeeFieldRefactoringSupport.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        boolean isModelNavigationElement = !ModelMergerUtil.createFilteringProcessor(o -> o.getNavigationElement() != originalElement).process((Object)field.getIdentifyingPsiElement());
        String name = ElementPresentationManager.getTypeNameForObject(field) + " " + ElementPresentationManager.getElementName(field);
        if (originalElement instanceof PsiField || originalElement instanceof PsiMethod && !isModelNavigationElement && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)originalElement))) {
            return Messages.showOkCancelDialog((String)JavaBundle.message((String)"find.field.accessors.prompt", (Object[])new Object[]{name}), (String)JavaBundle.message((String)"find.field.accessors.title", (Object[])new Object[0]), (String)JavaBundle.message((String)"include.accessors", (Object[])new Object[0]), (String)JavaBundle.message((String)"exclude.accessors", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/JavaeeFieldRefactoringSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFindUsagesHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptPsiMember";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "askUserIfAccessorsShouldBeTakenIntoAccount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

