/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

public class Chunk {
    private final DataInput input;
    private final short majorVersion;
    private final short minorVersion;
    protected int position;
    private byte[] data;

    public Chunk(DataInput input, int offset, byte[] reusableBuffer) throws IOException, InvalidJfrFileException {
        this.input = input;
        this.data = reusableBuffer;
        this.position = offset;
        ByteBufferWrapper buffer = this.fill(offset + 4);
        this.majorVersion = DataInputToolkit.readShort(buffer, offset);
        this.minorVersion = DataInputToolkit.readShort(buffer, offset + 2);
    }

    private Chunk(DataInput input, int offset, byte[] reusableBuffer, short majorVersion, short minorVersion) {
        this.input = input;
        this.data = reusableBuffer;
        this.position = offset;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public int getPosition() {
        return this.position;
    }

    public ByteBufferWrapper fill(long upToPosition) throws IOException, InvalidJfrFileException {
        int fillUpTo = Chunk.getArrayPosition(upToPosition);
        if (this.data.length < fillUpTo) {
            this.data = Arrays.copyOf(this.data, (int)((double)fillUpTo * 1.2));
        }
        if (fillUpTo > this.position) {
            this.input.readFully(this.data, this.position, fillUpTo - this.position);
            this.position = fillUpTo;
        }
        return ByteBufferWrapper.wrap(this.data).view(fillUpTo);
    }

    public void skip(long upToPosition) throws IOException, InvalidJfrFileException {
        int skipUpTo = Chunk.getArrayPosition(upToPosition);
        if (skipUpTo > this.position) {
            int skipped = this.input.skipBytes(skipUpTo - this.position);
            this.position += skipped;
        }
    }

    public byte[] getReusableBuffer() {
        return this.data;
    }

    private static int getArrayPosition(long pos) throws InvalidJfrFileException {
        if (pos > Integer.MAX_VALUE) {
            throw new InvalidJfrFileException();
        }
        return (int)pos;
    }

    public static class ByteBufferChunk
    extends Chunk {
        private final ByteBufferWrapper data;

        public ByteBufferChunk(ByteBufferWrapper data, int offset) {
            super(null, offset, null, DataInputToolkit.readShort(data, offset), DataInputToolkit.readShort(data, offset + 2));
            this.data = data;
            this.position = offset + 4;
        }

        @Override
        public ByteBufferWrapper fill(long upToPosition) throws IOException, InvalidJfrFileException {
            int fillUpTo = Chunk.getArrayPosition(upToPosition);
            if (this.data.limit() < fillUpTo) {
                throw new InvalidJfrFileException();
            }
            return this.data.view(fillUpTo);
        }

        @Override
        public void skip(long upToPosition) throws IOException, InvalidJfrFileException {
            int skipUpTo = Chunk.getArrayPosition(upToPosition);
            if (skipUpTo > this.position) {
                this.position = skipUpTo;
            }
        }

        @Override
        public byte[] getReusableBuffer() {
            return this.data.hasArray() ? this.data.array() : new byte[]{};
        }
    }
}

