/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.io.PrintStream;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvm5Adapter;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMConverter;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestSourceReadEvent;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmWriteEvent;

public class CucumberJvm5SMFormatter
extends CucumberJvmSMConverter
implements ConcurrentEventListener {
    private final EventHandler<TestCaseStarted> testCaseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            CucumberJvm5SMFormatter.this.handleTestCaseStarted(new CucumberJvm5Adapter.CucumberJvmTestCase(event.getTestCase()));
        }
    };
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            CucumberJvm5SMFormatter.this.handleTestCaseFinished(new CucumberJvm5Adapter.CucumberJvmTestCase(event.getTestCase()));
        }
    };
    private final EventHandler<TestRunFinished> testRunFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            CucumberJvm5SMFormatter.this.handleTestRunFinished();
        }
    };
    private final EventHandler<WriteEvent> writeEventHandler = new EventHandler<WriteEvent>(){

        public void receive(WriteEvent event) {
            CucumberJvm5SMFormatter.this.handleWriteEvent(new CucumberJvmWriteEvent(event.getText()));
        }
    };
    private final EventHandler<TestStepStarted> testStepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            CucumberJvm5SMFormatter.this.handleTestStepStarted(new CucumberJvm5Adapter.CucumberJvmTestStep(event.getTestStep()));
        }
    };
    private final EventHandler<TestStepFinished> testStepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            CucumberJvm5SMFormatter.this.handleTestStepFinished(new CucumberJvm5Adapter.CucumberJvmTestStepFinishedEvent(event));
        }
    };
    private final EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        public void receive(TestSourceRead event) {
            CucumberJvm5SMFormatter.this.handleTestSourceRead(new CucumberJvmTestSourceReadEvent(event.getUri().getPath(), event.getSource()));
        }
    };

    public CucumberJvm5SMFormatter() {
        this(System.out, null);
    }

    public CucumberJvm5SMFormatter(PrintStream out, String currentTimeValue) {
        super(out, currentTimeValue);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseStarted.class, this.testCaseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.testStepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.testRunFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
    }
}

