/*
 * Decompiled with CFR 0.152.
 */
package com.android;

import com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;

public abstract class ProgressManagerAdapter {
    private static ProgressManagerAdapter ourInstance;

    public static void checkCanceled() {
        ProgressManagerAdapter instance = ourInstance;
        if (instance != null) {
            instance.doCheckCanceled();
        }
    }

    public static void throwIfCancellation(Throwable t) {
        ProgressManagerAdapter instance = ourInstance;
        if (instance == null) {
            ProgressManagerAdapter.throwIfCancellationException(t);
        } else {
            instance.doThrowIfCancellation(t);
        }
    }

    protected abstract void doCheckCanceled();

    protected void doThrowIfCancellation(Throwable t) {
        ProgressManagerAdapter.throwIfCancellationException(t);
    }

    private static void throwIfCancellationException(Throwable t) {
        if (t instanceof CancellationException) {
            throw (CancellationException)t;
        }
    }

    protected static void setInstance(ProgressManagerAdapter instance) {
        Preconditions.checkState((ourInstance == null ? 1 : 0) != 0);
        ourInstance = instance;
    }
}

