/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.core.service;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.core.UtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.core.service.FileFormattingService;
import org.jetbrains.kotlin.tools.projectWizard.core.service.FileSystemWizardService;
import org.jetbrains.kotlin.tools.projectWizard.core.service.WizardService;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileDescriptor;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplate;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplateDescriptor;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTextDescriptor;
import org.jetbrains.kotlin.tools.projectWizard.templates.Template;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH&J \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\n0\u000eR\u00020\u000fj\u0002`\u00102\u0006\u0010\u0005\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/core/service/TemplateEngineService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/WizardService;", "()V", "getTemplateText", "", "template", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/FileTemplateDescriptor;", "renderTemplate", "data", "", "", "writeTemplate", "Lorg/jetbrains/kotlin/tools/projectWizard/core/TaskResult;", "", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Writer;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Writer;", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/FileTemplate;", "kotlin.project-wizard.core"})
public abstract class TemplateEngineService
implements WizardService {
    @NotNull
    public abstract String renderTemplate(@NotNull FileTemplateDescriptor var1, @NotNull Map<String, ? extends Object> var2);

    @NotNull
    protected final String getTemplateText(@NotNull FileTemplateDescriptor template2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
        try {
            String templateId = StringsKt.replace$default((String)template2.getTemplateId(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
            URL uRL = Template.class.getResource(templateId);
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"Template::class.java.getResource(templateId)");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            string = new String(byArray, charset);
        }
        catch (Throwable e) {
            throw (Throwable)new RuntimeException("Can not get template " + template2.getTemplateId(), e);
        }
        return string;
    }

    @NotNull
    public final TaskResult<Unit> writeTemplate(@NotNull Context.Writer $this$writeTemplate, @NotNull FileTemplate template2) {
        String string;
        block8: {
            String unformattedText;
            block7: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)$this$writeTemplate, (String)"$this$writeTemplate");
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                Context.Reader this_$iv = $this$writeTemplate;
                Function1 filter$iv = Context.Reader.service.1.INSTANCE;
                boolean $i$f$service = false;
                FileFormattingService formatter = (FileFormattingService)this_$iv.serviceByClass(Reflection.getOrCreateKotlinClass(FileFormattingService.class), filter$iv);
                FileDescriptor descriptor = template2.getDescriptor();
                if (descriptor instanceof FileTemplateDescriptor) {
                    string2 = this.renderTemplate((FileTemplateDescriptor)descriptor, template2.getData());
                } else if (descriptor instanceof FileTextDescriptor) {
                    string2 = ((FileTextDescriptor)descriptor).getText();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                unformattedText = string2;
                Path path2 = template2.getDescriptor().getRelativePath();
                String fileName = path2 != null && (path2 = path2.getFileName()) != null ? ((Object)path2).toString() : null;
                string = fileName;
                if (string == null) break block7;
                String string3 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = formatter.formatFile(unformattedText, it);
                if (string != null) break block8;
            }
            string = unformattedText;
        }
        String text = string;
        Context.Reader this_$iv = $this$writeTemplate;
        Function1 filter$iv = Context.Reader.service.1.INSTANCE;
        boolean $i$f$service = false;
        return ((FileSystemWizardService)this_$iv.serviceByClass(Reflection.getOrCreateKotlinClass(FileSystemWizardService.class), filter$iv)).createFile(UtilsKt.divNullable(template2.getRootPath(), template2.getDescriptor().getRelativePath()), text);
    }
}

