/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\f\u0010\u0007\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a8\u0006\b"}, d2={"assertEqualsToFile", "", "description", "", "expected", "Ljava/io/File;", "actual", "trimTrailingWhitespacesAndAddNewlineAtEOF", "intellij.platform.testFramework"})
@JvmName(name="EqualsToFile")
public final class EqualsToFile {
    /*
     * WARNING - void declaration
     */
    private static final String trimTrailingWhitespacesAndAddNewlineAtEOF(String $this$trimTrailingWhitespacesAndAddNewlineAtEOF) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$trimTrailingWhitespacesAndAddNewlineAtEOF, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var10_11 = p1;
            boolean bl2 = false;
            void v0 = var10_11;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string2 = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)v0))).toString();
            collection.add(string2);
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        boolean bl3 = false;
        String result = string;
        boolean bl4 = false;
        return StringsKt.endsWith$default((String)result, (String)"\n", (boolean)false, (int)2, null) ? result : result + "\n";
    }

    public static final void assertEqualsToFile(@NotNull String description, @NotNull File expected, @NotNull String actual) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        if (!expected.exists()) {
            FilesKt.writeText$default((File)expected, (String)actual, null, (int)2, null);
            TestCase.fail((String)("File didn't exist. New file was created (" + expected.getCanonicalPath() + ")."));
        }
        String string = FilesKt.readText$default((File)expected, null, (int)1, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = StringUtil.convertLineSeparators((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringUtil.convertLineSe\u2026pected.readText().trim())");
        String expectedText = EqualsToFile.trimTrailingWhitespacesAndAddNewlineAtEOF(string3);
        String string4 = actual;
        boolean bl2 = false;
        String string5 = StringUtil.convertLineSeparators((String)((Object)StringsKt.trim((CharSequence)string4)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringUtil.convertLineSeparators(actual.trim())");
        String actualText = EqualsToFile.trimTrailingWhitespacesAndAddNewlineAtEOF(string5);
        if (Intrinsics.areEqual((Object)expectedText, (Object)actualText) ^ true) {
            throw (Throwable)new FileComparisonFailure(description, expectedText, actualText, expected.getAbsolutePath());
        }
    }
}

