/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver;

import java.io.File;
import java.util.Arrays;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.util.internal.GFileUtils;

public abstract class FindGradleSources
implements TransformAction<TransformParameters.None> {
    @PathSensitive(value=PathSensitivity.NONE)
    @InputArtifact
    protected abstract Provider<FileSystemLocation> getInputArtifact();

    @Override
    public void transform(TransformOutputs outputs) {
        this.registerSourceDirectories(outputs);
    }

    private void registerSourceDirectories(TransformOutputs outputs) {
        File unzippedDistroDir = this.unzippedDistroDir();
        if (unzippedDistroDir == null) {
            return;
        }
        File srcDir = outputs.dir("gradle-src");
        File subprojects = new File(unzippedDistroDir, "subprojects");
        Arrays.stream(subprojects.listFiles(File::isDirectory)).forEach(subproject -> {
            File subprojectDestination = new File(srcDir, subproject.getName());
            GFileUtils.mkdirs(subprojectDestination);
            File subprojectSourceRoot = new File((File)subproject, "src/main");
            if (subprojectSourceRoot.exists()) {
                Arrays.stream(subprojectSourceRoot.listFiles(File::isDirectory)).forEach(subprojectSource -> GFileUtils.copyDirectory(subprojectSource, subprojectDestination));
            }
        });
    }

    private File unzippedDistroDir() {
        File[] unzippedDirs = this.getInputArtifact().get().getAsFile().listFiles();
        return unzippedDirs == null || unzippedDirs.length == 0 ? null : unzippedDirs[0];
    }
}

