/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.Receive;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.launcher.daemon.protocol.OutputMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedDispatchConnection<T>
implements Receive<T>,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedDispatchConnection.class);
    private final Lock lock = new ReentrantLock();
    private final RemoteConnection<T> delegate;
    private boolean dispatching;

    public SynchronizedDispatchConnection(RemoteConnection<T> delegate) {
        this.delegate = delegate;
    }

    public void dispatchAndFlush(T message2) {
        if (!(message2 instanceof OutputMessage)) {
            LOGGER.debug("thread {}: dispatching {}", (Object)Thread.currentThread().getId(), message2);
        }
        this.lock.lock();
        try {
            if (this.dispatching) {
                throw new IllegalStateException("This thread is already dispatching a message.");
            }
            this.dispatching = true;
            try {
                this.delegate.dispatch(message2);
                this.delegate.flush();
            }
            finally {
                this.dispatching = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T receive() {
        T result = this.delegate.receive();
        LOGGER.debug("thread {}: received {}", (Object)Thread.currentThread().getId(), result == null ? "null" : result.getClass());
        return result;
    }

    @Override
    public void stop() {
        LOGGER.debug("thread {}: stopping connection", (Object)Thread.currentThread().getId());
        this.delegate.stop();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

