/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonContext;

public class DefaultDaemonContext
implements DaemonContext {
    public static final org.gradle.internal.serialize.Serializer<DefaultDaemonContext> SERIALIZER = new Serializer();
    private final String uid;
    private final File javaHome;
    private final File daemonRegistryDir;
    private final Long pid;
    private final Integer idleTimeout;
    private final List<String> daemonOpts;
    private final DaemonParameters.Priority priority;

    public DefaultDaemonContext(String uid, File javaHome, File daemonRegistryDir, Long pid, Integer idleTimeout, List<String> daemonOpts, DaemonParameters.Priority priority) {
        this.uid = uid;
        this.javaHome = javaHome;
        this.daemonRegistryDir = daemonRegistryDir;
        this.pid = pid;
        this.idleTimeout = idleTimeout;
        this.daemonOpts = daemonOpts;
        this.priority = priority;
    }

    public String toString() {
        return String.format("DefaultDaemonContext[uid=%s,javaHome=%s,daemonRegistryDir=%s,pid=%s,idleTimeout=%s,priority=%s,daemonOpts=%s]", new Object[]{this.uid, this.javaHome, this.daemonRegistryDir, this.pid, this.idleTimeout, this.priority, Joiner.on((char)',').join(this.daemonOpts)});
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public File getJavaHome() {
        return this.javaHome;
    }

    @Override
    public File getDaemonRegistryDir() {
        return this.daemonRegistryDir;
    }

    @Override
    public Long getPid() {
        return this.pid;
    }

    @Override
    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public List<String> getDaemonOpts() {
        return this.daemonOpts;
    }

    @Override
    public DaemonParameters.Priority getPriority() {
        return this.priority;
    }

    private static class Serializer
    implements org.gradle.internal.serialize.Serializer<DefaultDaemonContext> {
        private Serializer() {
        }

        @Override
        public DefaultDaemonContext read(Decoder decoder) throws Exception {
            String uid = decoder.readNullableString();
            String pathname = decoder.readString();
            File javaHome = new File(pathname);
            File registryDir = new File(decoder.readString());
            Long pid = decoder.readBoolean() ? Long.valueOf(decoder.readLong()) : null;
            Integer idle = decoder.readBoolean() ? Integer.valueOf(decoder.readInt()) : null;
            int daemonOptCount = decoder.readInt();
            ArrayList<String> daemonOpts = new ArrayList<String>(daemonOptCount);
            for (int i = 0; i < daemonOptCount; ++i) {
                daemonOpts.add(decoder.readString());
            }
            DaemonParameters.Priority priority = decoder.readBoolean() ? DaemonParameters.Priority.values()[decoder.readInt()] : null;
            return new DefaultDaemonContext(uid, javaHome, registryDir, pid, idle, daemonOpts, priority);
        }

        @Override
        public void write(Encoder encoder, DefaultDaemonContext context) throws Exception {
            encoder.writeNullableString(context.uid);
            encoder.writeString(context.javaHome.getPath());
            encoder.writeString(context.daemonRegistryDir.getPath());
            encoder.writeBoolean(context.pid != null);
            if (context.pid != null) {
                encoder.writeLong(context.pid);
            }
            encoder.writeBoolean(context.idleTimeout != null);
            if (context.idleTimeout != null) {
                encoder.writeInt(context.idleTimeout);
            }
            encoder.writeInt(context.daemonOpts.size());
            for (String daemonOpt : context.daemonOpts) {
                encoder.writeString(daemonOpt);
            }
            encoder.writeBoolean(context.priority != null);
            if (context.priority != null) {
                encoder.writeInt(context.priority.ordinal());
            }
        }
    }
}

