/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class UnknownClassloaderImplementationSnapshot
extends ImplementationSnapshot {
    public UnknownClassloaderImplementationSnapshot(String typeName) {
        super(typeName);
    }

    @Override
    public void appendToHasher(Hasher hasher) {
        hasher.markAsInvalid(this.getUnknownReason());
    }

    @Override
    protected boolean isSameSnapshot(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnknownClassloaderImplementationSnapshot that = (UnknownClassloaderImplementationSnapshot)o;
        return this.getTypeName().equals(that.getTypeName());
    }

    @Override
    public HashCode getClassLoaderHash() {
        return null;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    @Nullable
    public String getUnknownReason() {
        return "was loaded with an unknown classloader (class '" + this.getTypeName() + "').";
    }

    public boolean equals(Object o) {
        return false;
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    public String toString() {
        return this.getTypeName() + "@<Unknown classloader>";
    }
}

