/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.util.Set;
import org.gradle.authentication.Authentication;
import org.gradle.authentication.http.BasicAuthentication;
import org.gradle.authentication.http.DigestAuthentication;
import org.gradle.authentication.http.HttpHeaderAuthentication;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.DefaultExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResourceLister;
import org.gradle.internal.resource.transport.http.HttpResourceUploader;
import org.gradle.internal.resource.transport.http.SslContextFactory;

public class HttpConnectorFactory
implements ResourceConnectorFactory {
    private static final Set<String> SUPPORTED_PROTOCOLS = ImmutableSet.of((Object)"http", (Object)"https");
    private static final Set<Class<? extends Authentication>> SUPPORTED_AUTHENTICATION = ImmutableSet.of(BasicAuthentication.class, DigestAuthentication.class, HttpHeaderAuthentication.class, AllSchemesAuthentication.class);
    private SslContextFactory sslContextFactory;
    private HttpClientHelper.Factory httpClientHelperFactory;

    public HttpConnectorFactory(SslContextFactory sslContextFactory, HttpClientHelper.Factory httpClientHelperFactory) {
        this.sslContextFactory = sslContextFactory;
        this.httpClientHelperFactory = httpClientHelperFactory;
    }

    @Override
    public Set<String> getSupportedProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    @Override
    public Set<Class<? extends Authentication>> getSupportedAuthentication() {
        return SUPPORTED_AUTHENTICATION;
    }

    @Override
    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification connectionDetails) {
        HttpClientHelper http = this.httpClientHelperFactory.create(DefaultHttpSettings.builder().withAuthenticationSettings(connectionDetails.getAuthentications()).withSslContextFactory(this.sslContextFactory).withRedirectVerifier(connectionDetails.getRedirectVerifier()).build());
        HttpResourceAccessor accessor = new HttpResourceAccessor(http);
        HttpResourceLister lister = new HttpResourceLister(accessor);
        HttpResourceUploader uploader = new HttpResourceUploader(http);
        return new DefaultExternalResourceConnector(accessor, lister, uploader);
    }
}

