/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.gcp.gcs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.api.client.auth.oauth2.Credential;
import org.gradle.internal.impldep.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import org.gradle.internal.impldep.com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import org.gradle.internal.impldep.com.google.api.client.googleapis.json.GoogleJsonResponseException;
import org.gradle.internal.impldep.com.google.api.client.http.AbstractInputStreamContent;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequestInitializer;
import org.gradle.internal.impldep.com.google.api.client.http.HttpTransport;
import org.gradle.internal.impldep.com.google.api.client.http.InputStreamContent;
import org.gradle.internal.impldep.com.google.api.client.http.javanet.NetHttpTransport;
import org.gradle.internal.impldep.com.google.api.client.json.JsonFactory;
import org.gradle.internal.impldep.com.google.api.client.json.jackson2.JacksonFactory;
import org.gradle.internal.impldep.com.google.api.services.storage.Storage;
import org.gradle.internal.impldep.com.google.api.services.storage.model.Objects;
import org.gradle.internal.impldep.com.google.api.services.storage.model.StorageObject;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.base.Suppliers;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.transport.gcp.gcs.GcsConnectionProperties;
import org.gradle.internal.resource.transport.gcp.gcs.RetryHttpInitializerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GcsClient.class);
    private final Storage storage;

    public static GcsClient create(GcsConnectionProperties gcsConnectionProperties) throws GeneralSecurityException, IOException {
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        Storage.Builder builder = new Storage.Builder((HttpTransport)transport, (JsonFactory)jsonFactory, null);
        if (gcsConnectionProperties.requiresAuthentication()) {
            Supplier<Credential> credentialSupplier = GcsClient.getCredentialSupplier((HttpTransport)transport, (JsonFactory)jsonFactory);
            builder.setHttpRequestInitializer((HttpRequestInitializer)new RetryHttpInitializerWrapper(credentialSupplier));
        }
        if (gcsConnectionProperties.getEndpoint().isPresent()) {
            builder.setRootUrl(((URI)gcsConnectionProperties.getEndpoint().get()).toString());
        }
        if (gcsConnectionProperties.getServicePath().isPresent()) {
            builder.setServicePath((String)gcsConnectionProperties.getServicePath().get());
        }
        builder.setApplicationName("gradle");
        return new GcsClient(builder.build());
    }

    @VisibleForTesting
    GcsClient(Storage storage) {
        this.storage = storage;
    }

    public void put(InputStream inputStream, Long contentLength, URI destination) throws ResourceException {
        try {
            InputStreamContent contentStream = new InputStreamContent(null, inputStream);
            contentStream.setLength(contentLength.longValue());
            String bucket = destination.getHost();
            String path = GcsClient.cleanResourcePath(destination);
            StorageObject objectMetadata = new StorageObject().setName(path);
            Storage.Objects.Insert putRequest = this.storage.objects().insert(bucket, objectMetadata, (AbstractInputStreamContent)contentStream);
            LOGGER.debug("Attempting to put resource:[{}] into gcs bucket [{}]", (Object)putRequest.getName(), (Object)putRequest.getBucket());
            putRequest.execute();
        }
        catch (IOException e) {
            throw ResourceExceptions.putFailed(destination, e);
        }
    }

    @Nullable
    public StorageObject getResource(URI uri) throws ResourceException {
        LOGGER.debug("Attempting to get gcs resource: [{}]", (Object)uri.toString());
        String path = GcsClient.cleanResourcePath(uri);
        try {
            Storage.Objects.Get getRequest = this.storage.objects().get(uri.getHost(), path);
            return (StorageObject)getRequest.execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw ResourceExceptions.getFailed(uri, e);
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(uri, e);
        }
    }

    @VisibleForTesting
    InputStream getResourceStream(URI uri) throws IOException {
        String path = GcsClient.cleanResourcePath(uri);
        Storage.Objects.Get getObject = this.storage.objects().get(uri.getHost(), path);
        getObject.getMediaHttpDownloader().setDirectDownloadEnabled(false);
        return getObject.executeMediaAsInputStream();
    }

    @Nullable
    public List<String> list(URI uri) throws ResourceException {
        ArrayList results = new ArrayList();
        String path = GcsClient.cleanResourcePath(uri);
        try {
            Objects objects;
            Storage.Objects.List listRequest = this.storage.objects().list(uri.getHost()).setPrefix(path);
            do {
                if ((objects = (Objects)listRequest.execute()).getItems() != null) {
                    results.addAll(objects.getItems());
                }
                listRequest.setPageToken(objects.getNextPageToken());
            } while (null != objects.getNextPageToken());
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(uri, e);
        }
        ArrayList<String> resultStrings = new ArrayList<String>();
        for (StorageObject result : results) {
            resultStrings.add(result.getName());
        }
        return resultStrings;
    }

    private static String cleanResourcePath(URI uri) {
        String path;
        try {
            path = URLDecoder.decode(uri.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private static Supplier<Credential> getCredentialSupplier(final HttpTransport transport, final JsonFactory jsonFactory) {
        return Suppliers.memoize((Supplier)new Supplier<Credential>(){

            public Credential get() {
                try {
                    GoogleCredential googleCredential = GoogleCredential.getApplicationDefault((HttpTransport)transport, (JsonFactory)jsonFactory);
                    return googleCredential.createScoped(Collections.singletonList("https://www.googleapis.com/auth/devstorage.read_write"));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to get Google credentials for GCS connection", e);
                }
            }
        });
    }
}

