/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.base.Suppliers;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.internal.os.OperatingSystem;

public interface JvmInstallationMetadata {
    public static DefaultJvmInstallationMetadata from(File javaHome, String implementationVersion, String runtimeVersion, String jvmVersion, String vendor, String implementationName) {
        return new DefaultJvmInstallationMetadata(javaHome, implementationVersion, runtimeVersion, jvmVersion, vendor, implementationName);
    }

    public static JvmInstallationMetadata failure(File javaHome, String errorMessage) {
        return new FailureInstallationMetadata(javaHome, errorMessage, null);
    }

    public static JvmInstallationMetadata failure(File javaHome, Exception cause) {
        return new FailureInstallationMetadata(javaHome, cause.getMessage(), cause);
    }

    public JavaVersion getLanguageVersion();

    public String getImplementationVersion();

    public String getRuntimeVersion();

    public String getJvmVersion();

    public JvmVendor getVendor();

    public Path getJavaHome();

    public String getDisplayName();

    public boolean hasCapability(JavaInstallationCapability var1);

    public String getErrorMessage();

    public Throwable getErrorCause();

    public boolean isValidInstallation();

    public static class FailureInstallationMetadata
    implements JvmInstallationMetadata {
        private final File javaHome;
        private final String errorMessage;
        @Nullable
        private final Exception cause;

        private FailureInstallationMetadata(File javaHome, String errorMessage, @Nullable Exception cause) {
            this.javaHome = javaHome;
            this.errorMessage = errorMessage;
            this.cause = cause;
        }

        @Override
        public JavaVersion getLanguageVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getImplementationVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getRuntimeVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getJvmVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public JvmVendor getVendor() {
            throw this.unsupportedOperation();
        }

        @Override
        public Path getJavaHome() {
            return this.javaHome.toPath();
        }

        @Override
        public String getDisplayName() {
            return "Invalid installation: " + this.getErrorMessage();
        }

        @Override
        public boolean hasCapability(JavaInstallationCapability capability) {
            return false;
        }

        private UnsupportedOperationException unsupportedOperation() {
            return new UnsupportedOperationException("Installation is not valid. Original error message: " + this.getErrorMessage());
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public Throwable getErrorCause() {
            return this.cause;
        }

        @Override
        public boolean isValidInstallation() {
            return false;
        }
    }

    public static class DefaultJvmInstallationMetadata
    implements JvmInstallationMetadata {
        private final JavaVersion languageVersion;
        private final String vendor;
        private final String implementationName;
        private final Path javaHome;
        private final String implementationVersion;
        private final String runtimeVersion;
        private final String jvmVersion;
        private final Supplier<Set<JavaInstallationCapability>> capabilities = Suppliers.memoize(this::gatherCapabilities);

        private DefaultJvmInstallationMetadata(File javaHome, String implementationVersion, String runtimeVersion, String jvmVersion, String vendor, String implementationName) {
            this.javaHome = javaHome.toPath();
            this.implementationVersion = implementationVersion;
            this.languageVersion = JavaVersion.toVersion(implementationVersion);
            this.runtimeVersion = runtimeVersion;
            this.jvmVersion = jvmVersion;
            this.vendor = vendor;
            this.implementationName = implementationName;
        }

        @Override
        public JavaVersion getLanguageVersion() {
            return this.languageVersion;
        }

        @Override
        public String getImplementationVersion() {
            return this.implementationVersion;
        }

        @Override
        public String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @Override
        public String getJvmVersion() {
            return this.jvmVersion;
        }

        @Override
        public JvmVendor getVendor() {
            return JvmVendor.fromString(this.vendor);
        }

        @Override
        public Path getJavaHome() {
            return this.javaHome;
        }

        @Override
        public String getDisplayName() {
            String vendor = this.determineVendorName();
            String installationType = this.determineInstallationType(vendor);
            return MessageFormat.format("{0}{1}", vendor, installationType);
        }

        private String determineVendorName() {
            JvmVendor.KnownJvmVendor vendor = this.getVendor().getKnownVendor();
            if (vendor == JvmVendor.KnownJvmVendor.ORACLE && this.implementationName != null && this.implementationName.contains("OpenJDK")) {
                return "OpenJDK";
            }
            return this.getVendor().getDisplayName();
        }

        private String determineInstallationType(String vendor) {
            if (this.hasCapability(JavaInstallationCapability.JAVA_COMPILER)) {
                if (!vendor.toLowerCase().contains("jdk")) {
                    return " JDK";
                }
                return "";
            }
            return " JRE";
        }

        @Override
        public boolean hasCapability(JavaInstallationCapability capability) {
            return ((Set)this.capabilities.get()).contains((Object)capability);
        }

        private Set<JavaInstallationCapability> gatherCapabilities() {
            boolean isJ9vm;
            HashSet<JavaInstallationCapability> capabilities = new HashSet<JavaInstallationCapability>(2);
            File javaCompiler = new File(new File(this.javaHome.toFile(), "bin"), OperatingSystem.current().getExecutableName("javac"));
            if (javaCompiler.exists()) {
                capabilities.add(JavaInstallationCapability.JAVA_COMPILER);
            }
            if (isJ9vm = this.implementationName.contains("J9")) {
                capabilities.add(JavaInstallationCapability.J9_VIRTUAL_MACHINE);
            }
            return capabilities;
        }

        @Override
        public String getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Throwable getErrorCause() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValidInstallation() {
            return true;
        }
    }

    public static enum JavaInstallationCapability {
        JAVA_COMPILER,
        J9_VIRTUAL_MACHINE;

    }
}

