/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.EnumMap;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.jvm.inspection.MetadataProbe;
import org.gradle.internal.jvm.inspection.ProbedSystemProperty;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.util.internal.GFileUtils;

public class DefaultJvmMetadataDetector
implements JvmMetadataDetector {
    private final ExecHandleFactory execHandleFactory;
    private final TemporaryFileProvider temporaryFileProvider;

    @Inject
    public DefaultJvmMetadataDetector(ExecHandleFactory execHandleFactory, TemporaryFileProvider temporaryFileProvider) {
        this.execHandleFactory = execHandleFactory;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    @Override
    public JvmInstallationMetadata getMetadata(File javaHome) {
        if (javaHome == null || !javaHome.exists()) {
            return this.failure(javaHome, "No such directory: " + javaHome);
        }
        if (Jvm.current().getJavaHome().equals(javaHome)) {
            return this.getMetadataFromCurrentJvm(javaHome);
        }
        return this.getMetadataFromInstallation(javaHome);
    }

    private JvmInstallationMetadata getMetadataFromCurrentJvm(File javaHome) {
        EnumMap<ProbedSystemProperty, String> result = new EnumMap<ProbedSystemProperty, String>(ProbedSystemProperty.class);
        for (ProbedSystemProperty type : ProbedSystemProperty.values()) {
            if (type == ProbedSystemProperty.Z_ERROR) continue;
            result.put(type, System.getProperty(type.getSystemPropertyKey()));
        }
        return this.asMetadata(javaHome, result);
    }

    private JvmInstallationMetadata asMetadata(File javaHome, EnumMap<ProbedSystemProperty, String> metadata) {
        String implementationVersion = metadata.get((Object)ProbedSystemProperty.VERSION);
        if (implementationVersion == null) {
            return this.failure(javaHome, metadata.get((Object)ProbedSystemProperty.Z_ERROR));
        }
        try {
            JavaVersion.toVersion(implementationVersion);
        }
        catch (IllegalArgumentException e) {
            return this.failure(javaHome, "Cannot parse version number: " + implementationVersion);
        }
        String runtimeVersion = metadata.get((Object)ProbedSystemProperty.RUNTIME_VERSION);
        String jvmVersion = metadata.get((Object)ProbedSystemProperty.VM_VERSION);
        String vendor = metadata.get((Object)ProbedSystemProperty.VENDOR);
        String implementationName = metadata.get((Object)ProbedSystemProperty.VM);
        return JvmInstallationMetadata.from(javaHome, implementationVersion, runtimeVersion, jvmVersion, vendor, implementationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JvmInstallationMetadata getMetadataFromInstallation(File jdkPath) {
        File tmpDir = this.temporaryFileProvider.createTemporaryDirectory("jvm", "probe", new String[0]);
        File probe = this.writeProbeClass(tmpDir);
        ExecHandleBuilder exec = this.execHandleFactory.newExec();
        exec.setWorkingDir(probe.getParentFile());
        exec.executable(DefaultJvmMetadataDetector.javaExecutable(jdkPath));
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream errorOutput = new ByteArrayOutputStream();
            String mainClassname = Files.getNameWithoutExtension((String)probe.getName());
            exec.args("-cp", ".", mainClassname);
            exec.setStandardOutput(out);
            exec.setErrorOutput(errorOutput);
            exec.setIgnoreExitValue(true);
            ExecResult result = exec.build().start().waitForFinish();
            int exitValue = result.getExitValue();
            if (exitValue == 0) {
                JvmInstallationMetadata jvmInstallationMetadata = this.parseExecOutput(jdkPath, out.toString());
                return jvmInstallationMetadata;
            }
            JvmInstallationMetadata jvmInstallationMetadata = this.failure(jdkPath, "Command returned unexpected result code: " + exitValue + "\nError output:\n" + errorOutput);
            return jvmInstallationMetadata;
        }
        catch (ExecException ex) {
            JvmInstallationMetadata jvmInstallationMetadata = this.failure(jdkPath, ex);
            return jvmInstallationMetadata;
        }
        finally {
            GFileUtils.deleteQuietly(tmpDir);
        }
    }

    private static File javaExecutable(File jdkPath) {
        return new File(new File(jdkPath, "bin"), OperatingSystem.current().getExecutableName("java"));
    }

    private JvmInstallationMetadata parseExecOutput(File jdkPath, String probeResult) {
        String[] split = probeResult.split(System.getProperty("line.separator"));
        if (split.length != ProbedSystemProperty.values().length - 1) {
            String errorMessage = "Unexpected command output: \n" + probeResult;
            return this.failure(jdkPath, errorMessage);
        }
        EnumMap<ProbedSystemProperty, String> result = new EnumMap<ProbedSystemProperty, String>(ProbedSystemProperty.class);
        for (ProbedSystemProperty type : ProbedSystemProperty.values()) {
            if (type == ProbedSystemProperty.Z_ERROR) continue;
            result.put(type, split[type.ordinal()].trim());
        }
        return this.asMetadata(jdkPath, result);
    }

    private JvmInstallationMetadata failure(File jdkPath, String errorMessage) {
        return JvmInstallationMetadata.failure(jdkPath, errorMessage);
    }

    private JvmInstallationMetadata failure(File jdkPath, Exception cause) {
        return JvmInstallationMetadata.failure(jdkPath, cause.getMessage());
    }

    private File writeProbeClass(File tmpDir) {
        File probe = new MetadataProbe().writeClass(tmpDir);
        return probe;
    }
}

