/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.fingerprint.impl;

import java.util.function.Consumer;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.execution.fingerprint.FileNormalizationSpec;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.gradle.internal.execution.fingerprint.impl.DefaultFileNormalizationSpec;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class DefaultInputFingerprinter
implements InputFingerprinter {
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
    private final ValueSnapshotter valueSnapshotter;

    public DefaultInputFingerprinter(FileCollectionFingerprinterRegistry fingerprinterRegistry, ValueSnapshotter valueSnapshotter) {
        this.fingerprinterRegistry = fingerprinterRegistry;
        this.valueSnapshotter = valueSnapshotter;
    }

    @Override
    public InputFingerprinter.Result fingerprintInputProperties(ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFingerprints, Consumer<InputFingerprinter.InputVisitor> inputs) {
        InputCollectingVisitor visitor = new InputCollectingVisitor(previousValueSnapshots, this.fingerprinterRegistry, this.valueSnapshotter, knownValueSnapshots, knownFingerprints);
        inputs.accept(visitor);
        return visitor.complete();
    }

    @Override
    public FileCollectionFingerprinterRegistry getFingerprinterRegistry() {
        return this.fingerprinterRegistry;
    }

    @VisibleForTesting
    public static class InputFingerprints
    implements InputFingerprinter.Result {
        private final ImmutableSortedMap<String, ValueSnapshot> valueSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fileFingerprints;

        public InputFingerprints(ImmutableSortedMap<String, ValueSnapshot> valueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fileFingerprints) {
            this.valueSnapshots = valueSnapshots;
            this.fileFingerprints = fileFingerprints;
        }

        @Override
        public ImmutableSortedMap<String, ValueSnapshot> getValueSnapshots() {
            return this.valueSnapshots;
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFileFingerprints() {
            return this.fileFingerprints;
        }
    }

    private static class InputCollectingVisitor
    implements InputFingerprinter.InputVisitor {
        private final ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots;
        private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
        private final ValueSnapshotter valueSnapshotter;
        private final ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFingerprints;
        private final ImmutableSortedMap.Builder<String, ValueSnapshot> valueSnapshotsBuilder = ImmutableSortedMap.naturalOrder();
        private final ImmutableSortedMap.Builder<String, CurrentFileCollectionFingerprint> fingerprintsBuilder = ImmutableSortedMap.naturalOrder();

        public InputCollectingVisitor(ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, FileCollectionFingerprinterRegistry fingerprinterRegistry, ValueSnapshotter valueSnapshotter, ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFingerprints) {
            this.previousValueSnapshots = previousValueSnapshots;
            this.fingerprinterRegistry = fingerprinterRegistry;
            this.valueSnapshotter = valueSnapshotter;
            this.knownValueSnapshots = knownValueSnapshots;
            this.knownFingerprints = knownFingerprints;
        }

        @Override
        public void visitInputProperty(String propertyName, InputFingerprinter.ValueSupplier value) {
            if (this.knownValueSnapshots.containsKey((Object)propertyName)) {
                return;
            }
            Object actualValue = value.getValue();
            try {
                ValueSnapshot previousSnapshot = (ValueSnapshot)this.previousValueSnapshots.get((Object)propertyName);
                if (previousSnapshot == null) {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue));
                } else {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue, previousSnapshot));
                }
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Input property '%s' with value '%s' cannot be serialized.", propertyName, value.getValue()), e);
            }
        }

        @Override
        public void visitInputFileProperty(String propertyName, InputFingerprinter.InputPropertyType type, InputFingerprinter.FileValueSupplier value) {
            if (this.knownFingerprints.containsKey((Object)propertyName)) {
                return;
            }
            FileNormalizationSpec normalizationSpec = DefaultFileNormalizationSpec.from(value.getNormalizer(), value.getDirectorySensitivity());
            CurrentFileCollectionFingerprint fingerprint = this.fingerprinterRegistry.getFingerprinter(normalizationSpec).fingerprint(value.getFiles());
            this.fingerprintsBuilder.put((Object)propertyName, (Object)fingerprint);
        }

        public InputFingerprinter.Result complete() {
            return new InputFingerprints((ImmutableSortedMap<String, ValueSnapshot>)this.valueSnapshotsBuilder.build(), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)this.fingerprintsBuilder.build());
        }
    }
}

