/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.fingerprint;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.ValueSnapshot;

public interface InputFingerprinter {
    public Result fingerprintInputProperties(ImmutableSortedMap<String, ValueSnapshot> var1, ImmutableSortedMap<String, ValueSnapshot> var2, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> var3, Consumer<InputVisitor> var4);

    public FileCollectionFingerprinterRegistry getFingerprinterRegistry();

    public static interface Result {
        public ImmutableSortedMap<String, ValueSnapshot> getValueSnapshots();

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFileFingerprints();
    }

    public static class FileValueSupplier
    implements ValueSupplier {
        private final Object value;
        private final Class<? extends FileNormalizer> normalizer;
        private final DirectorySensitivity directorySensitivity;
        private final Supplier<FileCollection> files;

        public FileValueSupplier(@Nullable Object value, Class<? extends FileNormalizer> normalizer, DirectorySensitivity directorySensitivity, Supplier<FileCollection> files) {
            this.value = value;
            this.normalizer = normalizer;
            this.directorySensitivity = directorySensitivity;
            this.files = files;
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.value;
        }

        public Class<? extends FileNormalizer> getNormalizer() {
            return this.normalizer;
        }

        public DirectorySensitivity getDirectorySensitivity() {
            return this.directorySensitivity;
        }

        public FileCollection getFiles() {
            return this.files.get();
        }
    }

    public static interface ValueSupplier {
        @Nullable
        public Object getValue();
    }

    public static enum InputPropertyType {
        NON_INCREMENTAL(false, false),
        INCREMENTAL(true, false),
        PRIMARY(true, true);

        private final boolean incremental;
        private final boolean skipWhenEmpty;

        private InputPropertyType(boolean incremental, boolean skipWhenEmpty) {
            this.incremental = incremental;
            this.skipWhenEmpty = skipWhenEmpty;
        }

        public boolean isIncremental() {
            return this.incremental;
        }

        public boolean isSkipWhenEmpty() {
            return this.skipWhenEmpty;
        }
    }

    public static interface InputVisitor {
        default public void visitInputProperty(String propertyName, ValueSupplier value) {
        }

        default public void visitInputFileProperty(String propertyName, InputPropertyType type, FileValueSupplier value) {
        }
    }
}

