/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.exception;

import java.util.ArrayList;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.exception.ExceptionCollector;

public class MultipleBuildFailuresExceptionAnalyser
implements ExceptionAnalyser {
    private final ExceptionCollector collector;

    public MultipleBuildFailuresExceptionAnalyser(ExceptionCollector collector) {
        this.collector = collector;
    }

    @Override
    public RuntimeException transform(Throwable failure) {
        ArrayList failures = new ArrayList();
        if (failure instanceof MultipleBuildFailures) {
            MultipleBuildFailures multipleBuildFailures = (MultipleBuildFailures)failure;
            for (Throwable throwable : multipleBuildFailures.getCauses()) {
                this.collector.collectFailures(throwable, failures);
            }
            if (failures.size() == 1 && failures.get(0) instanceof RuntimeException) {
                return (RuntimeException)failures.get(0);
            }
            multipleBuildFailures.replaceCauses(failures);
            return multipleBuildFailures;
        }
        this.collector.collectFailures(failure, failures);
        if (failures.size() == 1 && failures.get(0) instanceof RuntimeException) {
            return (RuntimeException)failures.get(0);
        }
        return new MultipleBuildFailures(failures);
    }
}

