/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.MutableReference;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultPlanExecutor
implements PlanExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPlanExecutor.class);
    private final int executorCount;
    private final ExecutorFactory executorFactory;
    private final WorkerLeaseService workerLeaseService;
    private final BuildCancellationToken cancellationToken;
    private final ResourceLockCoordinationService coordinationService;

    public DefaultPlanExecutor(ParallelismConfiguration parallelismConfiguration, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
        this.executorFactory = executorFactory;
        this.cancellationToken = cancellationToken;
        this.coordinationService = coordinationService;
        int numberOfParallelExecutors = parallelismConfiguration.getMaxWorkerCount();
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ExecutionPlan executionPlan, Collection<? super Throwable> failures, Action<Node> nodeExecutor) {
        ManagedExecutor executor = this.executorFactory.create("Execution worker for '" + executionPlan.getDisplayName() + "'");
        try {
            WorkerLeaseRegistry.WorkerLease parentWorkerLease = this.workerLeaseService.getCurrentWorkerLease();
            this.startAdditionalWorkers(executionPlan, nodeExecutor, executor, parentWorkerLease);
            new ExecutorWorker(executionPlan, nodeExecutor, parentWorkerLease, this.cancellationToken, this.coordinationService).run();
            this.awaitCompletion(executionPlan, failures);
        }
        finally {
            executor.stop();
        }
    }

    private void awaitCompletion(ExecutionPlan executionPlan, Collection<? super Throwable> failures) {
        this.coordinationService.withStateLock(resourceLockState -> {
            if (executionPlan.allNodesComplete()) {
                executionPlan.collectFailures(failures);
                return ResourceLockState.Disposition.FINISHED;
            }
            return ResourceLockState.Disposition.RETRY;
        });
    }

    private void startAdditionalWorkers(ExecutionPlan executionPlan, Action<? super Node> nodeExecutor, Executor executor, WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
        LOGGER.debug("Using {} parallel executor threads", (Object)this.executorCount);
        for (int i = 1; i < this.executorCount; ++i) {
            executor.execute(new ExecutorWorker(executionPlan, nodeExecutor, parentWorkerLease, this.cancellationToken, this.coordinationService));
        }
    }

    private static class ExecutorWorker
    implements Runnable {
        private final ExecutionPlan executionPlan;
        private final Action<? super Node> nodeExecutor;
        private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
        private final BuildCancellationToken cancellationToken;
        private final ResourceLockCoordinationService coordinationService;

        private ExecutorWorker(ExecutionPlan executionPlan, Action<? super Node> nodeExecutor, WorkerLeaseRegistry.WorkerLease parentWorkerLease, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
            this.executionPlan = executionPlan;
            this.nodeExecutor = nodeExecutor;
            this.parentWorkerLease = parentWorkerLease;
            this.cancellationToken = cancellationToken;
            this.coordinationService = coordinationService;
        }

        @Override
        public void run() {
            boolean nodesRemaining;
            AtomicLong busy = new AtomicLong(0L);
            Timer totalTimer = Time.startTimer();
            Timer executionTimer = Time.startTimer();
            WorkerLeaseRegistry.WorkerLease childLease = this.parentWorkerLease.createChild();
            while (nodesRemaining = this.executeNextNode(childLease, work -> {
                LOGGER.info("{} ({}) started.", work, (Object)Thread.currentThread());
                executionTimer.reset();
                this.nodeExecutor.execute((Node)work);
                long duration = executionTimer.getElapsedMillis();
                busy.addAndGet(duration);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("{} ({}) completed. Took {}.", new Object[]{work, Thread.currentThread(), TimeFormatting.formatDurationVerbose(duration)});
                }
            })) {
            }
            long total = totalTimer.getElapsedMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Execution worker [{}] finished, busy: {}, idle: {}", new Object[]{Thread.currentThread(), TimeFormatting.formatDurationVerbose(busy.get()), TimeFormatting.formatDurationVerbose(total - busy.get())});
            }
        }

        private boolean executeNextNode(WorkerLeaseRegistry.WorkerLease workerLease, Action<Node> nodeExecutor) {
            MutableReference selected = MutableReference.empty();
            MutableBoolean nodesRemaining = new MutableBoolean();
            this.coordinationService.withStateLock(resourceLockState -> {
                if (this.cancellationToken.isCancellationRequested()) {
                    this.executionPlan.cancelExecution();
                }
                nodesRemaining.set(this.executionPlan.hasNodesRemaining());
                if (!nodesRemaining.get()) {
                    return ResourceLockState.Disposition.FINISHED;
                }
                try {
                    selected.set(this.executionPlan.selectNext(workerLease, (ResourceLockState)resourceLockState));
                }
                catch (Throwable t) {
                    resourceLockState.releaseLocks();
                    this.executionPlan.abortAllAndFail(t);
                    nodesRemaining.set(false);
                }
                if (selected.get() == null && nodesRemaining.get()) {
                    return ResourceLockState.Disposition.RETRY;
                }
                return ResourceLockState.Disposition.FINISHED;
            });
            Node selectedNode = (Node)selected.get();
            if (selectedNode != null) {
                this.execute(selectedNode, workerLease, nodeExecutor);
            }
            return nodesRemaining.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(Node selected, WorkerLeaseRegistry.WorkerLease workerLease, Action<Node> nodeExecutor) {
            try {
                if (!selected.isComplete()) {
                    try {
                        nodeExecutor.execute(selected);
                    }
                    catch (Throwable e) {
                        selected.setExecutionFailure(e);
                    }
                }
            }
            finally {
                this.coordinationService.withStateLock(state2 -> {
                    this.executionPlan.finishedExecuting(selected);
                    return DefaultResourceLockCoordinationService.unlock(workerLease).transform((ResourceLockState)state2);
                });
            }
        }
    }
}

