/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import javax.annotation.Nonnull;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.util.GradleVersion;

public class VersionSpecificCacheDirectory
implements Comparable<VersionSpecificCacheDirectory> {
    private final File dir;
    private final GradleVersion version;

    public VersionSpecificCacheDirectory(File dir, GradleVersion version) {
        this.dir = (File)Preconditions.checkNotNull((Object)dir, (Object)"dir must not be null");
        this.version = (GradleVersion)Preconditions.checkNotNull((Object)version, (Object)"version must not be null");
    }

    public File getDir() {
        return this.dir;
    }

    public GradleVersion getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionSpecificCacheDirectory that = (VersionSpecificCacheDirectory)o;
        return this.dir.equals(that.dir) && this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.dir.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    @Override
    public int compareTo(@Nonnull VersionSpecificCacheDirectory that) {
        return this.version.compareTo(that.version);
    }
}

