/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import java.io.File;
import java.util.LinkedList;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.testing.junit.result.AggregateTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.BinaryResultBackedTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.DefaultTestReport;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.util.internal.CollectionUtils;

public class TestReport
extends DefaultTask {
    private File destinationDir;
    private ConfigurableFileCollection resultDirs = this.getObjectFactory().fileCollection();

    @Inject
    protected BuildOperationExecutor getBuildOperationExecutor() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFiles
    @SkipWhenEmpty
    public FileCollection getTestResultDirs() {
        return this.resultDirs;
    }

    private void addTo(Object result, ConfigurableFileCollection dirs) {
        if (result instanceof Test) {
            Test test = (Test)result;
            dirs.from(test.getBinaryResultsDirectory());
        } else if (result instanceof Iterable) {
            Iterable iterable = (Iterable)result;
            for (Object nested : iterable) {
                this.addTo(nested, dirs);
            }
        } else {
            dirs.from(result);
        }
    }

    public void setTestResultDirs(Iterable<File> testResultDirs) {
        this.resultDirs = this.getObjectFactory().fileCollection();
        this.reportOn(testResultDirs);
    }

    public void reportOn(Object ... results) {
        for (Object result : results) {
            this.addTo(result, this.resultDirs);
        }
    }

    @TaskAction
    void generateReport() {
        TestResultsProvider resultsProvider;
        block3: {
            resultsProvider = this.createAggregateProvider();
            try {
                if (resultsProvider.isHasResults()) {
                    DefaultTestReport testReport = new DefaultTestReport(this.getBuildOperationExecutor());
                    testReport.generateReport(resultsProvider, this.getDestinationDir());
                    break block3;
                }
                this.getLogger().info("{} - no binary test results found in dirs: {}.", this.getPath(), this.getTestResultDirs().getFiles());
                this.setDidWork(false);
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable(resultsProvider).stop();
                throw throwable;
            }
        }
        CompositeStoppable.stoppable(resultsProvider).stop();
    }

    private TestResultsProvider createAggregateProvider() {
        LinkedList resultsProviders = new LinkedList();
        try {
            FileCollection resultDirs = this.getTestResultDirs();
            if (resultDirs.getFiles().size() == 1) {
                return new BinaryResultBackedTestResultsProvider(resultDirs.getSingleFile());
            }
            return new AggregateTestResultsProvider(CollectionUtils.collect(resultDirs, resultsProviders, new Transformer<TestResultsProvider, File>(){

                @Override
                public TestResultsProvider transform(File dir) {
                    return new BinaryResultBackedTestResultsProvider(dir);
                }
            }));
        }
        catch (RuntimeException e) {
            CompositeStoppable.stoppable(resultsProviders).stop();
            throw e;
        }
    }
}

