/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import groovy.lang.Closure;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultReportContainer<T extends Report>
extends DefaultNamedDomainObjectSet<T>
implements ReportContainer<T> {
    private NamedDomainObjectSet<T> enabled = this.matching(new Spec<T>(){

        @Override
        public boolean isSatisfiedBy(T element) {
            return (Boolean)element.getRequired().get();
        }
    });

    public DefaultReportContainer(Class<? extends T> type, Instantiator instantiator, CollectionCallbackActionDecorator callbackActionDecorator) {
        super(type, instantiator, Report.NAMER, callbackActionDecorator);
    }

    @Override
    protected void assertMutableCollectionContents() {
        throw new ReportContainer.ImmutableViolationException();
    }

    @Override
    public NamedDomainObjectSet<T> getEnabled() {
        return this.enabled;
    }

    @Override
    public ReportContainer<T> configure(Closure cl) {
        ConfigureUtil.configureSelf(cl, this);
        return this;
    }

    @Nullable
    @Internal
    public T getFirstEnabled() {
        SortedMap map = this.enabled.getAsMap();
        if (map.isEmpty()) {
            return null;
        }
        return (T)((Report)map.get(map.firstKey()));
    }

    protected <N extends T> N add(Class<N> clazz, Object ... constructionArgs) {
        Report report = (Report)this.getInstantiator().newInstance(clazz, constructionArgs);
        String name = report.getName();
        if (name.equals("enabled")) {
            throw new InvalidUserDataException("Reports that are part of a ReportContainer cannot be named 'enabled'");
        }
        this.getStore().add(report);
        this.index();
        return (N)report;
    }

    @Override
    public Map<String, T> getEnabledReports() {
        return this.getEnabled().getAsMap();
    }
}

