/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.GradleException;
import org.gradle.api.NonExtensible;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.api.internal.provider.ValueSourceProviderFactory;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.internal.Cast;
import org.gradle.internal.Try;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.org.jetbrains.annotations.NotNull;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;

public class DefaultValueSourceProviderFactory
implements ValueSourceProviderFactory {
    private final InstantiatorFactory instantiatorFactory;
    private final IsolatableFactory isolatableFactory;
    private final GradleProperties gradleProperties;
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    private final AnonymousListenerBroadcast<ValueSourceProviderFactory.Listener> broadcaster;
    private final IsolationScheme<ValueSource, ValueSourceParameters> isolationScheme = new IsolationScheme<ValueSource, ValueSourceParameters.None>(ValueSource.class, ValueSourceParameters.class, ValueSourceParameters.None.class);
    private final InstanceGenerator paramsInstantiator;
    private final InstanceGenerator specInstantiator;

    public DefaultValueSourceProviderFactory(ConfigurationTimeBarrier configurationTimeBarrier, ListenerManager listenerManager, InstantiatorFactory instantiatorFactory, IsolatableFactory isolatableFactory, GradleProperties gradleProperties, ServiceLookup services) {
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.broadcaster = listenerManager.createAnonymousBroadcaster(ValueSourceProviderFactory.Listener.class);
        this.instantiatorFactory = instantiatorFactory;
        this.isolatableFactory = isolatableFactory;
        this.gradleProperties = gradleProperties;
        this.paramsInstantiator = instantiatorFactory.decorateScheme().withServices(services).instantiator();
        this.specInstantiator = instantiatorFactory.decorateLenientScheme().withServices(services).instantiator();
    }

    @Override
    public <T, P extends ValueSourceParameters> Provider<T> createProviderOf(Class<? extends ValueSource<T, P>> valueSourceType, Action<? super ValueSourceSpec<P>> configureAction) {
        try {
            Class<P> parametersType = this.extractParametersTypeOf(valueSourceType);
            ValueSourceParameters parameters = parametersType != null ? (ValueSourceParameters)this.paramsInstantiator.newInstance(parametersType, new Object[0]) : null;
            this.configureParameters(parameters, configureAction);
            return this.instantiateValueSourceProvider(valueSourceType, parametersType, parameters);
        }
        catch (GradleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GradleException(this.couldNotCreateProviderOf(valueSourceType), e);
        }
    }

    @Override
    public void addListener(ValueSourceProviderFactory.Listener listener) {
        this.broadcaster.add(listener);
    }

    @Override
    public void removeListener(ValueSourceProviderFactory.Listener listener) {
        this.broadcaster.remove(listener);
    }

    @Override
    @NotNull
    public <T, P extends ValueSourceParameters> Provider<T> instantiateValueSourceProvider(Class<? extends ValueSource<T, P>> valueSourceType, @Nullable Class<P> parametersType, @Nullable P parameters) {
        return new NonConfigurationTimeProvider(this.configurationTimeBarrier, new LazilyObtainedValue(this, valueSourceType, parametersType, parameters));
    }

    @NotNull
    public <T, P extends ValueSourceParameters> ValueSource<T, P> instantiateValueSource(Class<? extends ValueSource<T, P>> valueSourceType, @Nullable Class<P> parametersType, @Nullable P isolatedParameters) {
        DefaultServiceRegistry services = new DefaultServiceRegistry();
        services.add(GradleProperties.class, this.gradleProperties);
        if (isolatedParameters != null) {
            services.add(parametersType, isolatedParameters);
        }
        return this.instantiatorFactory.injectScheme().withServices(services).instantiator().newInstance(valueSourceType, new Object[0]);
    }

    @Nullable
    private <T, P extends ValueSourceParameters> Class<P> extractParametersTypeOf(Class<? extends ValueSource<T, P>> valueSourceType) {
        return this.isolationScheme.parameterTypeFor(valueSourceType, 1);
    }

    private <P extends ValueSourceParameters> void configureParameters(@Nullable P parameters, Action<? super ValueSourceSpec<P>> configureAction) {
        DefaultValueSourceSpec valueSourceSpec = (DefaultValueSourceSpec)Cast.uncheckedNonnullCast(this.specInstantiator.newInstance(DefaultValueSourceSpec.class, parameters));
        configureAction.execute(valueSourceSpec);
    }

    @Nullable
    private <P extends ValueSourceParameters> P isolateParameters(P parameters) {
        return this.isolatableFactory.isolate(parameters).isolate();
    }

    private <T, P extends ValueSourceParameters> void valueObtained(DefaultObtainedValue<T, P> obtainedValue) {
        ((ValueSourceProviderFactory.Listener)this.broadcaster.getSource()).valueObtained(obtainedValue);
    }

    private String couldNotCreateProviderOf(Class<?> valueSourceType) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Could not create provider for value source ");
        formatter.appendType(valueSourceType);
        formatter.append(".");
        return formatter.toString();
    }

    private static class DefaultObtainedValue<T, P extends ValueSourceParameters>
    implements ValueSourceProviderFactory.Listener.ObtainedValue<T, P> {
        private final Try<T> value;
        private final Class<? extends ValueSource<T, P>> valueSourceType;
        private final Class<P> parametersType;
        @Nullable
        private final P parameters;

        public DefaultObtainedValue(Try<T> value, Class<? extends ValueSource<T, P>> valueSourceType, Class<P> parametersType, @Nullable P parameters) {
            this.value = value;
            this.valueSourceType = valueSourceType;
            this.parametersType = parametersType;
            this.parameters = parameters;
        }

        @Override
        public Try<T> getValue() {
            return this.value;
        }

        @Override
        public Class<? extends ValueSource<T, P>> getValueSourceType() {
            return this.valueSourceType;
        }

        @Override
        public Class<P> getValueSourceParametersType() {
            return this.parametersType;
        }

        @Override
        public P getValueSourceParameters() {
            return this.parameters;
        }
    }

    private static class LazilyObtainedValue<T, P extends ValueSourceParameters> {
        public final Class<? extends ValueSource<T, P>> sourceType;
        @Nullable
        public final Class<P> parametersType;
        @Nullable
        public final P parameters;
        @Nullable
        private volatile Try<T> value = null;
        final /* synthetic */ DefaultValueSourceProviderFactory this$0;

        private LazilyObtainedValue(@Nullable Class<? extends ValueSource<T, P>> sourceType, @Nullable Class<P> parametersType, P parameters) {
            this.this$0 = var1_1;
            this.sourceType = sourceType;
            this.parametersType = parametersType;
            this.parameters = parameters;
        }

        public boolean hasBeenObtained() {
            return this.value != null;
        }

        public Try<T> obtain() {
            if (this.obtainValueForThe1stTime()) {
                this.this$0.valueObtained(this.obtainedValue());
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean obtainValueForThe1stTime() {
            boolean valueWasObtained = false;
            LazilyObtainedValue lazilyObtainedValue = this;
            synchronized (lazilyObtainedValue) {
                if (this.value == null) {
                    this.value = Try.ofFailable(() -> this.source().obtain());
                    valueWasObtained = true;
                }
            }
            return valueWasObtained;
        }

        @NotNull
        private ValueSource<T, P> source() {
            return this.this$0.instantiateValueSource(this.sourceType, this.parametersType, this.this$0.isolateParameters(this.parameters));
        }

        @NotNull
        private DefaultObtainedValue<T, P> obtainedValue() {
            return new DefaultObtainedValue<T, P>(this.value, this.sourceType, this.parametersType, this.parameters);
        }
    }

    public static abstract class ValueSourceProvider<T, P extends ValueSourceParameters>
    extends AbstractMinimalProvider<T> {
        protected final LazilyObtainedValue<T, P> value;

        public ValueSourceProvider(LazilyObtainedValue<T, P> value) {
            this.value = value;
        }

        public Class<? extends ValueSource<T, P>> getValueSourceType() {
            return this.value.sourceType;
        }

        @Nullable
        public Class<P> getParametersType() {
            return this.value.parametersType;
        }

        @Nullable
        public P getParameters() {
            return this.value.parameters;
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.externalValue();
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Nullable
        public Try<T> getObtainedValueOrNull() {
            return ((LazilyObtainedValue)this.value).value;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return null;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<T> calculateExecutionTimeValue() {
            if (this.value.hasBeenObtained()) {
                return ValueSupplier.ExecutionTimeValue.ofNullable(this.value.obtain().get());
            }
            return ValueSupplier.ExecutionTimeValue.changingValue(this);
        }

        @Override
        protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            this.vetoAtConfigurationTime();
            return ValueSupplier.Value.ofNullable(this.value.obtain().get());
        }

        protected abstract void vetoAtConfigurationTime();
    }

    private static class ConfigurationTimeProvider<T, P extends ValueSourceParameters>
    extends ValueSourceProvider<T, P> {
        public ConfigurationTimeProvider(LazilyObtainedValue<T, P> value) {
            super(value);
        }

        @Override
        protected void vetoAtConfigurationTime() {
        }

        @Override
        public Provider<T> forUseAtConfigurationTime() {
            return this;
        }
    }

    private static class NonConfigurationTimeProvider<T, P extends ValueSourceParameters>
    extends ValueSourceProvider<T, P> {
        private ConfigurationTimeBarrier configurationTimeBarrier;

        public NonConfigurationTimeProvider(ConfigurationTimeBarrier configurationTimeBarrier, LazilyObtainedValue<T, P> value) {
            super(value);
            this.configurationTimeBarrier = configurationTimeBarrier;
        }

        @Override
        protected void vetoAtConfigurationTime() {
            if (this.configurationTimeBarrier.isAtConfigurationTime()) {
                throw new IllegalStateException(this.cannotObtainValueAtConfigurationTime());
            }
        }

        @Override
        public Provider<T> forUseAtConfigurationTime() {
            return new ConfigurationTimeProvider(this.value);
        }

        private String cannotObtainValueAtConfigurationTime() {
            TreeFormatter message2 = new TreeFormatter();
            message2.node("Cannot obtain value from provider of ");
            if (Describable.class.isAssignableFrom(this.value.sourceType)) {
                message2.append(((Describable)((Object)this.value.source())).getDisplayName());
            } else {
                message2.appendType(this.value.sourceType);
            }
            return message2.append(" at configuration time.").node("Use a provider returned by 'forUseAtConfigurationTime()' instead.").toString();
        }
    }

    @NonExtensible
    public static abstract class DefaultValueSourceSpec<P extends ValueSourceParameters>
    implements ValueSourceSpec<P> {
        private final P parameters;

        public DefaultValueSourceSpec(P parameters) {
            this.parameters = parameters;
        }

        @Override
        public P getParameters() {
            return this.parameters;
        }

        @Override
        public void parameters(Action<? super P> configureAction) {
            configureAction.execute(this.parameters);
        }
    }
}

