/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.ArrayDeque;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.initialization.ClassLoaderScopeId;
import org.gradle.internal.impldep.com.google.common.base.Joiner;

public class ClassLoaderScopeIdentifier
implements ClassLoaderScopeId {
    @Nullable
    private final ClassLoaderScopeIdentifier parent;
    private final String name;

    public ClassLoaderScopeIdentifier(@Nullable ClassLoaderScopeIdentifier parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public ClassLoaderScopeIdentifier child(String name) {
        return new ClassLoaderScopeIdentifier(this, name);
    }

    @Override
    @Nullable
    public ClassLoaderScopeIdentifier getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ClassLoaderId localId() {
        return new Id(this, false);
    }

    ClassLoaderId exportId() {
        return new Id(this, true);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderScopeIdentifier that = (ClassLoaderScopeIdentifier)o;
        return this.name.equals(that.name) && Objects.equals(this.parent, that.parent);
    }

    @Override
    public int hashCode() {
        int result = Objects.hashCode(this.parent);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    String getPath() {
        ArrayDeque<String> names = new ArrayDeque<String>();
        names.add(this.name);
        ClassLoaderScopeIdentifier nextParent = this.parent;
        while (nextParent != null) {
            names.addFirst(nextParent.name);
            nextParent = nextParent.parent;
        }
        return Joiner.on((String)":").join(names);
    }

    public String toString() {
        return "ClassLoaderScopeIdentifier{" + this.getPath() + "}";
    }

    private static class Id
    implements ClassLoaderId {
        private final ClassLoaderScopeIdentifier identifier;
        private final boolean export;

        public Id(ClassLoaderScopeIdentifier identifier, boolean export) {
            this.identifier = identifier;
            this.export = export;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return this.export == id.export && this.identifier.equals(id.identifier);
        }

        @Override
        public int hashCode() {
            int result = this.identifier.hashCode();
            result = 31 * result + Boolean.hashCode(this.export);
            return result;
        }

        @Override
        public String getDisplayName() {
            return this.identifier.getPath() + "(" + (this.export ? "export" : "local") + ")";
        }

        public String toString() {
            return "ClassLoaderScopeIdentifier.Id{" + this.getDisplayName() + "}";
        }
    }
}

