/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.internal.GUtil;

public class DefaultSourceDirectorySet
extends CompositeFileTree
implements SourceDirectorySet {
    private final List<Object> source = new ArrayList<Object>();
    private final String name;
    private final String displayName;
    private final FileCollectionFactory fileCollectionFactory;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final PatternSet patterns;
    private final PatternSet filter;
    private final FileCollection dirs;
    private final DirectoryProperty destinationDirectory;
    private final DirectoryProperty classesDirectory;
    private TaskProvider<?> compileTaskProvider;

    public DefaultSourceDirectorySet(String name, String displayName, Factory<PatternSet> patternSetFactory, FileCollectionFactory fileCollectionFactory, DirectoryFileTreeFactory directoryFileTreeFactory, ObjectFactory objectFactory) {
        this(name, displayName, patternSetFactory.create(), patternSetFactory.create(), fileCollectionFactory, directoryFileTreeFactory, objectFactory.directoryProperty(), objectFactory.directoryProperty());
    }

    DefaultSourceDirectorySet(String name, String displayName, PatternSet patterns, PatternSet filters, FileCollectionFactory fileCollectionFactory, DirectoryFileTreeFactory directoryFileTreeFactory, DirectoryProperty destinationDirectory, DirectoryProperty classesDirectory) {
        this.name = name;
        this.displayName = displayName;
        this.fileCollectionFactory = fileCollectionFactory;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patterns = patterns;
        this.filter = filters;
        this.dirs = new FileCollectionAdapter(new SourceDirectories());
        this.destinationDirectory = destinationDirectory;
        this.classesDirectory = classesDirectory;
    }

    public DefaultSourceDirectorySet(SourceDirectorySet sourceSet) {
        if (!(sourceSet instanceof DefaultSourceDirectorySet)) {
            throw new RuntimeException("Invalid source set type:" + this.source.getClass());
        }
        DefaultSourceDirectorySet defaultSourceSet = (DefaultSourceDirectorySet)sourceSet;
        this.name = defaultSourceSet.name;
        this.displayName = defaultSourceSet.displayName;
        this.fileCollectionFactory = defaultSourceSet.fileCollectionFactory;
        this.directoryFileTreeFactory = defaultSourceSet.directoryFileTreeFactory;
        this.patterns = defaultSourceSet.patterns;
        this.filter = defaultSourceSet.filter;
        this.dirs = new FileCollectionAdapter(new SourceDirectories());
        this.destinationDirectory = defaultSourceSet.destinationDirectory;
        this.classesDirectory = defaultSourceSet.classesDirectory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FileCollection getSourceDirectories() {
        return this.dirs;
    }

    @Override
    public Set<File> getSrcDirs() {
        LinkedHashSet<File> dirs = new LinkedHashSet<File>();
        for (DirectoryTree tree : this.getSrcDirTrees()) {
            dirs.add(tree.getDir());
        }
        return dirs;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patterns.getIncludes();
    }

    @Override
    public Set<String> getExcludes() {
        return this.patterns.getExcludes();
    }

    @Override
    public PatternFilterable setIncludes(Iterable<String> includes) {
        this.patterns.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public PatternFilterable setExcludes(Iterable<String> excludes) {
        this.patterns.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public PatternFilterable include(String ... includes) {
        this.patterns.include(includes);
        return this;
    }

    @Override
    public PatternFilterable include(Iterable<String> includes) {
        this.patterns.include((Iterable)includes);
        return this;
    }

    @Override
    public PatternFilterable include(Spec<FileTreeElement> includeSpec) {
        this.patterns.include((Spec)includeSpec);
        return this;
    }

    @Override
    public PatternFilterable include(Closure includeSpec) {
        this.patterns.include(includeSpec);
        return this;
    }

    @Override
    public PatternFilterable exclude(Iterable<String> excludes) {
        this.patterns.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public PatternFilterable exclude(String ... excludes) {
        this.patterns.exclude(excludes);
        return this;
    }

    @Override
    public PatternFilterable exclude(Spec<FileTreeElement> excludeSpec) {
        this.patterns.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public PatternFilterable exclude(Closure excludeSpec) {
        this.patterns.exclude(excludeSpec);
        return this;
    }

    @Override
    public PatternFilterable getFilter() {
        return this.filter;
    }

    @Override
    @Deprecated
    public File getOutputDir() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(SourceDirectorySet.class, "outputDir").replaceWith("classesDirectory")).willBeRemovedInGradle8().withDslReference().nagUser();
        return this.destinationDirectory.getAsFile().get();
    }

    @Override
    @Deprecated
    public void setOutputDir(Provider<File> provider) {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(SourceDirectorySet.class, "setOutputDir(Provider<File>)").withAdvice("Please use the destinationDirectory property instead.")).willBeRemovedInGradle8().withDslReference(SourceDirectorySet.class, "destinationDirectory").nagUser();
        this.destinationDirectory.set(this.classesDirectory.fileProvider((Provider)provider));
    }

    @Override
    @Deprecated
    public void setOutputDir(File outputDir) {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(SourceDirectorySet.class, "setOutputDir(File)").withAdvice("Please use the destinationDirectory property instead.")).willBeRemovedInGradle8().withDslReference(SourceDirectorySet.class, "destinationDirectory").nagUser();
        this.destinationDirectory.set(outputDir);
    }

    @Override
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    @Override
    public Provider<Directory> getClassesDirectory() {
        return this.classesDirectory;
    }

    @Override
    public <T extends Task> void compiledBy(TaskProvider<T> taskProvider, Function<T, DirectoryProperty> mapping) {
        this.compileTaskProvider = taskProvider;
        taskProvider.configure(task -> {
            if (taskProvider == this.compileTaskProvider) {
                ((DirectoryProperty)mapping.apply(task)).set(this.destinationDirectory);
            }
        });
        this.classesDirectory.set(taskProvider.flatMap(mapping::apply));
    }

    @Override
    public Set<DirectoryTree> getSrcDirTrees() {
        LinkedHashMap<File, DirectoryTree> trees = new LinkedHashMap<File, DirectoryTree>();
        for (DirectoryTree directoryTree : this.getSourceTrees()) {
            if (trees.containsKey(directoryTree.getDir())) continue;
            trees.put(directoryTree.getDir(), directoryTree);
        }
        return new LinkedHashSet<DirectoryTree>(trees.values());
    }

    protected Set<DirectoryFileTree> getSourceTrees() {
        LinkedHashSet<DirectoryFileTree> result = new LinkedHashSet<DirectoryFileTree>();
        for (Object path : this.source) {
            if (path instanceof DefaultSourceDirectorySet) {
                DefaultSourceDirectorySet nested = (DefaultSourceDirectorySet)path;
                result.addAll(nested.getSourceTrees());
                continue;
            }
            for (File srcDir : this.fileCollectionFactory.resolving(path)) {
                if (srcDir.exists() && !srcDir.isDirectory()) {
                    throw new InvalidUserDataException(String.format("Source directory '%s' is not a directory.", srcDir));
                }
                result.add(this.directoryFileTreeFactory.create(srcDir, this.patterns));
            }
        }
        return result;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        for (Object path : this.source) {
            if (path instanceof SourceDirectorySet) {
                context.add(((SourceDirectorySet)path).getBuildDependencies());
                continue;
            }
            context.add(this.fileCollectionFactory.resolving(path));
        }
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        for (DirectoryFileTree directoryTree : this.getSourceTrees()) {
            visitor.accept(this.fileCollectionFactory.treeOf(directoryTree.filter(this.filter)));
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public SourceDirectorySet srcDir(Object srcDir) {
        this.source.add(srcDir);
        return this;
    }

    @Override
    public SourceDirectorySet srcDirs(Object ... srcDirs) {
        this.source.addAll(Arrays.asList(srcDirs));
        return this;
    }

    @Override
    public SourceDirectorySet setSrcDirs(Iterable<?> srcPaths) {
        this.source.clear();
        GUtil.addToCollection(this.source, srcPaths);
        return this;
    }

    @Override
    public SourceDirectorySet source(SourceDirectorySet source) {
        this.source.add(source);
        return this;
    }

    private class SourceDirectories
    implements MinimalFileSet,
    Buildable {
        private SourceDirectories() {
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return DefaultSourceDirectorySet.this.getBuildDependencies();
        }

        @Override
        public Set<File> getFiles() {
            return DefaultSourceDirectorySet.this.getSrcDirs();
        }

        @Override
        public String getDisplayName() {
            return DefaultSourceDirectorySet.this.displayName;
        }
    }
}

