/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.CachingResourceHasher;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshotContext;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;

public class DefaultResourceSnapshotterCacheService
implements ResourceSnapshotterCacheService {
    private static final HashCode NO_HASH = Hashing.signature(CachingResourceHasher.class.getName() + " : no hash");
    private final PersistentIndexedCache<HashCode, HashCode> persistentCache;

    public DefaultResourceSnapshotterCacheService(PersistentIndexedCache<HashCode, HashCode> persistentCache) {
        this.persistentCache = persistentCache;
    }

    @Override
    public HashCode hashFile(RegularFileSnapshotContext fileSnapshotContext, RegularFileHasher hasher, HashCode configurationHash) {
        HashCode resourceHashCacheKey = DefaultResourceSnapshotterCacheService.resourceHashCacheKey(fileSnapshotContext.getSnapshot().getHash(), configurationHash);
        HashCode resourceHash = this.persistentCache.getIfPresent(resourceHashCacheKey);
        if (resourceHash != null) {
            if (resourceHash.equals(NO_HASH)) {
                return null;
            }
            return resourceHash;
        }
        resourceHash = hasher.hash(fileSnapshotContext);
        if (resourceHash != null) {
            this.persistentCache.put(resourceHashCacheKey, resourceHash);
        } else {
            this.persistentCache.put(resourceHashCacheKey, NO_HASH);
        }
        return resourceHash;
    }

    private static HashCode resourceHashCacheKey(HashCode contentHash, HashCode configurationHash) {
        Hasher hasher = Hashing.newHasher();
        hasher.putHash(configurationHash);
        hasher.putHash(contentHash);
        return hasher.hash();
    }
}

