/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMinimalDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.catalog.BundleModel;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;

public abstract class DependencyBundleValueSource
implements ValueSource<ExternalModuleDependencyBundle, Params> {
    @Override
    public ExternalModuleDependencyBundle obtain() {
        String bundle = (String)((Params)this.getParameters()).getBundleName().get();
        DefaultVersionCatalog config = (DefaultVersionCatalog)((Params)this.getParameters()).getConfig().get();
        BundleModel bundleModel = config.getBundle(bundle);
        return bundleModel.getComponents().stream().map(config::getDependencyData).map(this::createDependency).collect(Collectors.toCollection(() -> new DefaultBundle()));
    }

    private DefaultMinimalDependency createDependency(DependencyModel data) {
        ImmutableVersionConstraint version = data.getVersion();
        return new DefaultMinimalDependency(DefaultModuleIdentifier.newId(data.getGroup(), data.getName()), new DefaultMutableVersionConstraint(version));
    }

    private static class DefaultBundle
    extends ArrayList<MinimalExternalModuleDependency>
    implements ExternalModuleDependencyBundle {
        private DefaultBundle() {
        }
    }

    static interface Params
    extends ValueSourceParameters {
        public Property<String> getBundleName();

        public Property<DefaultVersionCatalog> getConfig();
    }
}

