/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.DefaultCachedMetadata;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleComponentAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.PersistentModuleMetadataCache;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.util.internal.BuildCommencedTimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModuleMetadataCache
implements ModuleMetadataCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentModuleMetadataCache.class);
    protected final BuildCommencedTimeProvider timeProvider;

    AbstractModuleMetadataCache(BuildCommencedTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public ModuleMetadataCache.CachedMetadata getCachedModuleDescriptor(ModuleComponentRepository repository, ModuleComponentIdentifier id) {
        ModuleComponentAtRepositoryKey key = this.createKey(repository, id);
        return this.get(key);
    }

    @Override
    public ModuleMetadataCache.CachedMetadata cacheMissing(ModuleComponentRepository repository, ModuleComponentIdentifier id) {
        LOGGER.debug("Recording absence of module descriptor in cache: {} [changing = {}]", (Object)id, (Object)false);
        ModuleComponentAtRepositoryKey key = this.createKey(repository, id);
        ModuleMetadataCacheEntry entry = ModuleMetadataCacheEntry.forMissingModule(this.timeProvider.getCurrentTime());
        DefaultCachedMetadata cachedMetaData = new DefaultCachedMetadata(entry, null, this.timeProvider);
        this.store(key, entry, cachedMetaData);
        return cachedMetaData;
    }

    @Override
    public ModuleMetadataCache.CachedMetadata cacheMetaData(ModuleComponentRepository repository, ModuleComponentIdentifier id, ModuleComponentResolveMetadata metadata) {
        LOGGER.debug("Recording module descriptor in cache: {} [changing = {}]", (Object)metadata.getId(), (Object)metadata.isChanging());
        ModuleComponentAtRepositoryKey key = this.createKey(repository, id);
        ModuleMetadataCacheEntry entry = this.createEntry(metadata);
        DefaultCachedMetadata cachedMetaData = new DefaultCachedMetadata(entry, metadata, this.timeProvider);
        return this.store(key, entry, cachedMetaData);
    }

    protected ModuleComponentAtRepositoryKey createKey(ModuleComponentRepository repository, ModuleComponentIdentifier id) {
        return new ModuleComponentAtRepositoryKey(repository.getId(), id);
    }

    private ModuleMetadataCacheEntry createEntry(ModuleComponentResolveMetadata metaData) {
        return ModuleMetadataCacheEntry.forMetaData(metaData, this.timeProvider.getCurrentTime());
    }

    protected abstract ModuleMetadataCache.CachedMetadata store(ModuleComponentAtRepositoryKey var1, ModuleMetadataCacheEntry var2, ModuleMetadataCache.CachedMetadata var3);

    protected abstract ModuleMetadataCache.CachedMetadata get(ModuleComponentAtRepositoryKey var1);
}

