/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public abstract class ExtraFieldInstrumenter
extends ClassVisitor {
    protected static final int ADDED_CODE_STACK_SIZE = 6;
    private static final String CLASS_INIT = "<clinit>";
    private static final int INTERFACE_FIELD_ACCESS = 4121;
    private static final int CLASS_FIELD_ACCESS = 4234;
    private static final int INIT_METHOD_ACCESS = 4106;
    private final String myFieldName;
    private final String myFieldType;
    private final String myFieldInitMethodName;
    protected final String myInternalClassName;
    private final boolean myJava8AndAbove;
    private final boolean myInterface;
    private final boolean myShouldCoverClinit;
    private boolean mySeenClinit = false;

    public ExtraFieldInstrumenter(ClassReader cr, ClassVisitor classVisitor, String className, String fieldName, String fieldType, String fieldInitName, boolean shouldCoverClinit) {
        super(589824, classVisitor);
        this.myFieldName = fieldName;
        this.myFieldType = fieldType;
        this.myFieldInitMethodName = fieldInitName;
        this.myInternalClassName = className.replace('.', '/');
        this.myInterface = (cr.getAccess() & 0x200) != 0;
        this.myJava8AndAbove = (cr.readInt(4) & 0xFFFF) >= 52;
        this.myShouldCoverClinit = shouldCoverClinit;
    }

    public abstract void initField(MethodVisitor var1);

    public MethodVisitor createMethodVisitor(ClassVisitor cv, MethodVisitor mv, MethodVisitor newMv, String name) {
        if (mv == null) {
            return null;
        }
        if (this.myFieldInitMethodName.equals(name)) {
            return mv;
        }
        if (CLASS_INIT.equals(name)) {
            if (this.myInterface && (this.myJava8AndAbove || this.myShouldCoverClinit)) {
                newMv = new MethodVisitor(589824, newMv){

                    public void visitCode() {
                        ExtraFieldInstrumenter.this.initField(this.mv);
                        ExtraFieldInstrumenter.this.mySeenClinit = true;
                        super.visitCode();
                    }
                };
            }
            if (!this.myShouldCoverClinit) {
                return newMv;
            }
        }
        if (this.myInterface) {
            return newMv;
        }
        return new MethodVisitor(589824, newMv){

            public void visitCode() {
                this.mv.visitMethodInsn(184, ExtraFieldInstrumenter.this.myInternalClassName, ExtraFieldInstrumenter.this.myFieldInitMethodName, "()V", false);
                super.visitCode();
            }
        };
    }

    protected MethodVisitor createMethodVisitor(MethodVisitor mv, MethodVisitor newMv, String name) {
        return this.createMethodVisitor(this, mv, newMv, name);
    }

    public void generateMembers(ClassVisitor cv) {
        if (this.myInterface) {
            if (!this.myJava8AndAbove && !this.mySeenClinit) {
                return;
            }
            cv.visitField(4121, this.myFieldName, this.myFieldType, null, null);
            if (this.mySeenClinit) {
                return;
            }
            this.generateExplicitClinitForInterfaces(cv);
        } else {
            cv.visitField(4234, this.myFieldName, this.myFieldType, null, null);
            this.createInitFieldMethod(cv);
        }
    }

    protected void generateMembers() {
        this.generateMembers(this);
    }

    private void createInitFieldMethod(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(4106, this.myFieldInitMethodName, "()V", null, null);
        mv.visitFieldInsn(178, this.myInternalClassName, this.myFieldName, this.myFieldType);
        Label alreadyInitialized = new Label();
        mv.visitJumpInsn(199, alreadyInitialized);
        this.initField(mv);
        mv.visitLabel(alreadyInitialized);
        mv.visitInsn(177);
        mv.visitMaxs(6, 0);
        mv.visitEnd();
    }

    private void generateExplicitClinitForInterfaces(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(4105, CLASS_INIT, "()V", null, null);
        this.initField(mv);
        mv.visitInsn(177);
        mv.visitMaxs(6, 0);
        mv.visitEnd();
    }

    public String getInternalClassName() {
        return this.myInternalClassName;
    }

    public boolean isInterface() {
        return this.myInterface;
    }
}

