/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.jsp.highlighter.JavaInJspHighlighter;
import com.intellij.jsp.highlighter.NewJspFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.jsp.JspDirectiveHighlighter;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lexer.JspHighlightingLexer;
import com.intellij.openapi.editor.JspHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.jsp.el.ELElementType;
import com.intellij.psi.jsp.el.impl.ELHighlighter;
import com.intellij.psi.jsp.el.impl.ELLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;

public class JspEditorHighlighter
extends LayeredLexerEditorHighlighter {
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    private Language myTemplateLanguage;

    public JspEditorHighlighter(EditorColorsScheme scheme, Project project, VirtualFile virtualFile) {
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)NewJspFileType.INSTANCE, (Project)project, (VirtualFile)virtualFile), scheme);
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        JavaInJspHighlighter javaHighlighter = JspWithOtherWorldIntegrationService.getInstance().createJavaHighlighter(project, virtualFile);
        LayerDescriptor javaLayer = new LayerDescriptor((SyntaxHighlighter)javaHighlighter, "\n", JspHighlighterColors.JSP_SCRIPTING_BACKGROUND);
        this.registerLayer((IElementType)BaseJspElementType.JSP_DECLARATION, javaLayer);
        this.registerLayer((IElementType)BaseJspElementType.JSP_SCRIPTLET, javaLayer);
        this.registerLayer((IElementType)BaseJspElementType.JSP_EXPRESSION, javaLayer);
        SyntaxHighlighter elHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)ELLanguage.INSTANCE, (Project)project, (VirtualFile)virtualFile);
        LayerDescriptor elLayer = new LayerDescriptor(elHighlighter, "\n", ELHighlighter.EL_BACKGROUND);
        this.registerLayer((IElementType)ELElementType.JSP_EL_HOLDER, elLayer);
        JspDirectiveHighlighter directiveHighlighter = new JspDirectiveHighlighter();
        LayerDescriptor directiveLayer = new LayerDescriptor((SyntaxHighlighter)directiveHighlighter, "\n", JspHighlighterColors.JSP_ACTION_AND_DIRECTIVE_BACKGROUND);
        this.registerLayer((IElementType)BaseJspElementType.JSP_DIRECTIVE, directiveLayer);
    }

    protected boolean updateLayers() {
        Language templateLanguage = this.getCurrentTemplateLanguage();
        if (!Comparing.equal((Object)this.myTemplateLanguage, (Object)templateLanguage)) {
            this.unregisterLayer(JspTokenType.JSP_TEMPLATE_DATA);
            this.myTemplateLanguage = templateLanguage;
            SyntaxHighlighter templateLanguageHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.myTemplateLanguage, (Project)this.myProject, (VirtualFile)this.myVirtualFile);
            this.registerLayer(JspTokenType.JSP_TEMPLATE_DATA, new LayerDescriptor(templateLanguageHighlighter, "", null));
            return true;
        }
        return false;
    }

    private Language getCurrentTemplateLanguage() {
        FileViewProvider viewProvider;
        if (this.myProject != null && !this.myProject.isDisposed() && this.myVirtualFile != null && (viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(this.myVirtualFile)) instanceof TemplateLanguageFileViewProvider) {
            ((JspHighlightingLexer)this.getLexer()).setFile(viewProvider);
            return ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage();
        }
        return HTMLLanguage.INSTANCE;
    }
}

