/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.source;

import com.intellij.jsp.el.impl.ELResolveUtil;
import com.intellij.jsp.source.JspImplicitVariableImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.jsp.tagext.TagData;
import org.jetbrains.annotations.NonNls;

public final class JspImplUtil {
    @NonNls
    private static final String TAG_JSPX_DIRECTIVE_NAME = "directive.tag";
    @NonNls
    private static final String TAG_DIRECTIVE_NAME = "tag";
    @NonNls
    private static final String DYNAMIC_ATTRIBUTES_ATTRNAME = "dynamic-attributes";
    @NonNls
    private static final String PAGE_CONTEXT_VAR_NAME = "pageContext";

    public static TagData getTagData(XmlTag action) {
        XmlAttribute[] attributes;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (XmlAttribute attribute : attributes = action.getAttributes()) {
            String name = attribute.getName();
            String attributeValue = action.getAttributeValue(name);
            if (attributeValue == null) continue;
            hashtable.put(name, attributeValue);
        }
        return new TagData(hashtable);
    }

    public static void addSharedImplicitVars(PsiElement scopeElement, JspFile jspxFile, List<? super JspImplicitVariable> vars) {
        XmlTag[] directiveTags;
        vars.add(new JspImplicitVariableImpl(scopeElement, PAGE_CONTEXT_VAR_NAME, "javax.servlet.jsp.PageContext", null));
        if (!jspxFile.isTagPage()) {
            return;
        }
        for (XmlTag directiveTag : jspxFile.getDirectiveTags(JspDirectiveKind.ATTRIBUTE, true)) {
            String name = directiveTag.getAttributeValue("name");
            if (name == null) continue;
            String typeStr = directiveTag.getAttributeValue("type");
            if (typeStr == null) {
                typeStr = "java.lang.String";
            }
            PsiType type = PsiImplUtil.buildTypeFromTypeString((String)typeStr, (PsiElement)directiveTag, (PsiFile)jspxFile);
            vars.add(new JspImplicitVariableImpl(scopeElement, name, type, (PsiElement)directiveTag, "NESTED"));
        }
        for (XmlTag d : directiveTags = jspxFile.getDirectiveTags(JspDirectiveKind.PAGE, false)) {
            String attributeValue;
            String localName = d.getLocalName();
            if (!TAG_JSPX_DIRECTIVE_NAME.equals(localName) && !TAG_DIRECTIVE_NAME.equals(localName) || (attributeValue = d.getAttributeValue(DYNAMIC_ATTRIBUTES_ATTRNAME)) == null) continue;
            vars.add(new JspImplicitVariableImpl(scopeElement, attributeValue, ELResolveUtil.createTypedMapType(scopeElement, "java.lang.String", "java.lang.String"), (PsiElement)d.getAttribute(DYNAMIC_ATTRIBUTES_ATTRNAME, null).getValueElement(), "NESTED"));
            break;
        }
    }
}

