/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.extractTag;

import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.jsp.extractTag.ExtractJspTagDialog;
import com.intellij.jsp.extractTag.ExtractTagHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractJspTagAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExtractJspTagAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setVisible(true);
        DataContext context = e.getDataContext();
        ExtractTagHandler handler = ExtractJspTagAction.getHandler(context);
        if (handler == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        e.getPresentation().setText(handler.getActionName());
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        e.getPresentation().setEnabled(editor != null && editor.getSelectionModel().hasSelection());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExtractJspTagAction.$$$reportNull$$$0(1);
        }
        DataContext context = e.getDataContext();
        BaseJspFile jspFile = BaseJspUtil.getJspFile((PsiElement)CommonDataKeys.PSI_FILE.getData(context));
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        assert (jspFile != null);
        Project project = jspFile.getProject();
        String tagName = null;
        String path = ExtractJspTagAction.guessLocation(jspFile, ExtractTagHandler.getHandler(jspFile));
        while (true) {
            VirtualFile dir;
            block10: {
                ExtractJspTagDialog dialog;
                if (!(dialog = new ExtractJspTagDialog(jspFile, tagName, path)).showAndGet()) {
                    return;
                }
                tagName = dialog.getTagName();
                path = dialog.getLocationPath();
                dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                if (dir == null) {
                    if (Messages.showOkCancelDialog((Project)project, (String)JavaeeJspBundle.message("dialog.message.does.not.exist.do.you.want.to.create.it", path), (String)JavaeeJspBundle.message("dialog.title.directory.not.exist", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                        String finalPath = path;
                        try {
                            dir = (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)project, () -> VfsUtil.createDirectoryIfMissing((String)finalPath));
                            break block10;
                        }
                        catch (IOException e1) {
                            Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)JavaeeJspBundle.message("dialog.title.error", new Object[0]));
                            continue;
                        }
                    }
                    return;
                }
            }
            try {
                ExtractJspTagAction.doCreateTag(jspFile, editor, tagName, dir);
                return;
            }
            catch (IncorrectOperationException ex) {
                Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)JavaeeJspBundle.message("dialog.title.error", new Object[0]));
                continue;
            }
            break;
        }
    }

    public static PsiFile doCreateTag(BaseJspFile jspFile, Editor editor, String tagName, VirtualFile dir) throws IncorrectOperationException {
        ExtractTagHandler handler = ExtractTagHandler.getHandler(jspFile);
        assert (handler != null);
        Project project = jspFile.getProject();
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(dir);
        assert (psiDirectory != null);
        return (PsiFile)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{jspFile}).withName(handler.getActionName()).compute(() -> {
            PsiFile tagFile = psiDirectory.createFile(tagName + "." + handler.getTagExtension());
            String tagFileText = handler.getTagFileText(editor, (PsiFile)jspFile);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document doc = documentManager.getDocument(tagFile);
            assert (doc != null);
            doc.replaceString(0, doc.getTextLength(), (CharSequence)(tagFileText == null ? "" : tagFileText));
            String path = dir.getPath() + "/";
            int pos = path.lastIndexOf(handler.getTagFileLocation() + "/");
            String tagdir = path.substring(pos, path.length() - 1);
            String prefix = handler.getExistingPrefix(jspFile, tagdir);
            if (prefix == null) {
                String[] strings = dir.getPath().split("/");
                prefix = strings[strings.length - 1];
                XmlTag rootTag = jspFile.getRootTag();
                handler.addDeclaration(rootTag, jspFile, prefix, tagdir);
            }
            Document jspDoc = documentManager.getDocument((PsiFile)jspFile);
            assert (jspDoc != null);
            documentManager.doPostponedOperationsAndUnblockDocument(jspDoc);
            int start = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            jspDoc.replaceString(start, end, (CharSequence)("<" + prefix + ":" + tagName + "/>"));
            editor.getSelectionModel().removeSelection();
            return tagFile;
        });
    }

    @Nullable
    private static ExtractTagHandler getHandler(DataContext context) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file == null) {
            return null;
        }
        BaseJspFile jspFile = BaseJspUtil.getJspFile((PsiElement)file);
        return jspFile == null ? null : ExtractTagHandler.getHandler(jspFile);
    }

    @NlsSafe
    private static String guessLocation(BaseJspFile context, ExtractTagHandler handler) {
        VirtualFile file;
        WebDirectoryElement element;
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)context);
        if (webFacet != null && (element = WebUtil.getWebUtil().findWebDirectoryElement("/", webFacet)) != null && (file = element.getOriginalVirtualFile()) != null) {
            return handler.guessLocation(file);
        }
        VirtualFile file2 = context.getVirtualFile();
        assert (file2 != null);
        return file2.getParent().getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/jsp/extractTag/ExtractJspTagAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

