/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.copyright;

import com.intellij.jsp.copyright.UpdateJspFileCopyright;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import java.util.ArrayList;

public class UpdateJspxFileCopyright
extends UpdateJspFileCopyright {
    private static final Logger logger = Logger.getInstance((String)UpdateJspxFileCopyright.class.getName());

    public UpdateJspxFileCopyright(Project project, Module module, VirtualFile root, CopyrightProfile options) {
        super(project, module, root, options);
    }

    @Override
    protected void scanFile() {
        logger.debug("updating " + this.getFile().getVirtualFile());
        XmlDocument doc = ((XmlFile)this.getFile()).getDocument();
        XmlProlog xmlProlog = doc.getProlog();
        if (xmlProlog == null) {
            return;
        }
        PsiElement elem = xmlProlog.getFirstChild();
        PsiElement docTypeStart = null;
        while (elem != null) {
            if (elem instanceof XmlDoctype) {
                docTypeStart = elem;
                break;
            }
            elem = this.getNextSibling(elem);
        }
        PsiElement first = xmlProlog.getFirstChild();
        int location = this.getLanguageOptions().getFileLocation();
        if (docTypeStart != null) {
            ArrayList comments = new ArrayList();
            this.collectComments(doc.getFirstChild(), (PsiElement)xmlProlog, comments);
            this.collectComments(first, docTypeStart, comments);
            this.checkComments(first, location == 1, comments);
            this.checkComments(docTypeStart, (PsiElement)doc.getRootTag(), location == 2);
            return;
        }
        if (location == 1) {
            location = 2;
        }
        ArrayList comments = new ArrayList();
        this.collectComments(doc.getFirstChild(), (PsiElement)xmlProlog, comments);
        this.collectComments(first, (PsiElement)doc.getRootTag(), comments);
        this.checkComments((PsiElement)doc.getRootTag(), location == 2, comments);
    }

    public static class UpdateJspxCopyrightsProvider
    extends UpdateCopyrightsProvider {
        public UpdateCopyright createInstance(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options) {
            return new UpdateJspxFileCopyright(project, module, file, options);
        }

        public LanguageOptions getDefaultOptions() {
            return UpdateJspxCopyrightsProvider.createDefaultOptions((boolean)false);
        }
    }
}

