/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.copyright;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import com.maddyhome.idea.copyright.psi.UpdatePsiFileCopyright;

public class UpdateJspFileCopyright
extends UpdatePsiFileCopyright {
    private static final Logger logger = Logger.getInstance((String)UpdateJspFileCopyright.class.getName());

    public UpdateJspFileCopyright(Project project, Module module, VirtualFile root, CopyrightProfile options) {
        super(project, module, root, options);
    }

    protected boolean accept() {
        return this.getFile() instanceof JspFile;
    }

    protected void scanFile() {
        logger.debug("updating " + this.getFile().getVirtualFile());
        XmlDocument doc = ((XmlFile)this.getFile()).getDocument();
        XmlTag root = doc.getRootTag();
        if (root == null) {
            return;
        }
        PsiElement elem = root.getFirstChild();
        PsiElement docTypeStart = null;
        PsiElement docTypeEnd = null;
        PsiElement firstTag = null;
        block0: while (elem != null) {
            if (elem instanceof XmlToken) {
                if ("<!DOCTYPE".equals(elem.getText())) {
                    docTypeStart = elem;
                    while ((elem = this.getNextSibling(elem)) != null) {
                        if (elem instanceof PsiWhiteSpace) continue;
                        if (!(elem instanceof XmlToken)) continue block0;
                        if (elem.getText().endsWith(">")) {
                            docTypeEnd = elem = this.getNextSibling(elem);
                            continue block0;
                        }
                        if (!elem.getText().startsWith("<")) continue;
                        docTypeEnd = elem;
                        continue block0;
                    }
                    continue;
                }
                firstTag = elem;
                break;
            }
            if (elem instanceof XmlTag && !(elem instanceof JspDirective)) {
                firstTag = elem;
                break;
            }
            elem = this.getNextSibling(elem);
        }
        PsiElement first = root.getFirstChild();
        int location = this.getLanguageOptions().getFileLocation();
        if (docTypeStart != null) {
            this.checkComments(first, docTypeStart, location == 1);
            first = docTypeEnd;
        } else if (location == 1) {
            location = 2;
        }
        if (firstTag != null) {
            this.checkComments(first, firstTag, location == 2);
        } else if (location == 2) {
            this.checkComments(first, first, true);
        }
    }

    protected PsiElement getPreviousSibling(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement res = element.getPrevSibling();
        if (res == null && element.getParent() instanceof XmlText) {
            res = element.getParent().getPrevSibling();
        }
        if (res instanceof XmlText) {
            XmlText text = (XmlText)res;
            res = text.getLastChild() != null ? text.getLastChild() : text.getPrevSibling();
        }
        return res;
    }

    protected PsiElement getNextSibling(PsiElement element) {
        PsiElement res;
        if (element == null) {
            return null;
        }
        PsiElement psiElement = res = element instanceof XmlText ? element.getFirstChild() : element.getNextSibling();
        if (res instanceof XmlText) {
            res = res.getFirstChild() != null ? res.getFirstChild() : res.getNextSibling();
        }
        if (res == null && element.getParent() instanceof XmlText) {
            res = element.getParent().getNextSibling();
        }
        return res;
    }

    public static class UpdateJspCopyrightsProvider
    extends UpdateCopyrightsProvider {
        public UpdateCopyright createInstance(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options) {
            return new UpdateJspFileCopyright(project, module, file, options);
        }

        public LanguageOptions getDefaultOptions() {
            return UpdateCopyrightsProvider.createDefaultOptions((boolean)false);
        }
    }
}

