/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.codeInspection.unescapedEl;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Nullable;

public class SafeTagInfo {
    public String namespace;
    @Nullable
    public String tagName;
    @Nullable
    public String attributeName;
    public boolean fix;

    public SafeTagInfo() {
    }

    public SafeTagInfo(String namespace, @Nullable String tagName, @Nullable String attributeName, boolean fix) {
        this.namespace = namespace;
        this.tagName = tagName;
        this.attributeName = attributeName;
        this.fix = fix;
    }

    public boolean matchAttribute(XmlAttribute attribute) {
        if (this.attributeName != null && !attribute.getLocalName().equals(this.attributeName)) {
            return false;
        }
        XmlTag tag = attribute.getParent();
        if (this.tagName != null && !tag.getLocalName().equals(this.tagName)) {
            return false;
        }
        return tag.getNamespace().equals(this.namespace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SafeTagInfo info = (SafeTagInfo)o;
        if (this.fix != info.fix) {
            return false;
        }
        if (this.attributeName != null ? !this.attributeName.equals(info.attributeName) : info.attributeName != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(info.namespace) : info.namespace != null) {
            return false;
        }
        return !(this.tagName != null ? !this.tagName.equals(info.tagName) : info.tagName != null);
    }
}

