/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.jsp.JspManager;
import com.intellij.jsp.base.JavaeeJspBaseBundle;
import com.intellij.jsp.codeInspection.WrapInTagFix;
import com.intellij.jsp.codeInspection.unescapedEl.SafeTagInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JspAbsolutePathInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JspAbsolutePathInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                PsiReference[] references;
                if (!value.getValue().startsWith("/") || !HtmlUtil.isHtmlTagContainingFile((PsiElement)value)) {
                    return;
                }
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class);
                if (tag == null || !tag.getNamespacePrefix().isEmpty()) {
                    return;
                }
                JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)value);
                if (jspFile == null) {
                    return;
                }
                for (PsiReference reference : references = value.getReferences()) {
                    if (!(reference instanceof FileReferenceOwner)) continue;
                    PsiFileReference fileReference = ((FileReferenceOwner)reference).getLastFileReference();
                    if (fileReference instanceof FileReference && ((FileReference)fileReference).getFileReferenceSet().isAbsolutePathReference()) {
                        ArrayList<Object> fixes = new ArrayList<Object>(2);
                        PsiFile file = value.getContainingFile();
                        if (!(file instanceof JspFile) && JspManager.getInstance((Project)value.getProject()).getTldFileByUri("http://java.sun.com/jsp/jstl/core", jspFile) != null) {
                            fixes.add(new WrapInTagFix(new SafeTagInfo("http://java.sun.com/jsp/jstl/core", "url", "value", true)));
                        }
                        fixes.add(new AddDynamicPrefixFix());
                        TextRange range = ElementManipulators.getValueTextRange((PsiElement)value);
                        holder.registerProblem((PsiElement)value, range, JavaeeJspBundle.message("inspection.message.absolute.paths.not.recommended.in.jsps", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    }
                    return;
                }
            }
        };
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = JavaeeJspBaseBundle.message("jsp.inspections.group.name", new Object[0]);
        if (string == null) {
            JspAbsolutePathInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "JspAbsolutePathInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/codeInspection/JspAbsolutePathInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/codeInspection/JspAbsolutePathInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddDynamicPrefixFix
    implements LocalQuickFix {
        private AddDynamicPrefixFix() {
        }

        @NotNull
        public String getName() {
            String string = JavaeeJspBundle.message("intention.name.add.dynamic.prefix", new Object[0]);
            if (string == null) {
                AddDynamicPrefixFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaeeJspBaseBundle.message("jsp.inspections.group.name", new Object[0]);
            if (string == null) {
                AddDynamicPrefixFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddDynamicPrefixFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddDynamicPrefixFix.$$$reportNull$$$0(3);
            }
            XmlAttributeValue value = (XmlAttributeValue)descriptor.getPsiElement();
            JspFile jsp = JspPsiUtil.getJspFile((PsiElement)value);
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)jsp);
            TextRange range = value.getValueTextRange();
            document.insertString(range.getStartOffset(), (CharSequence)"${pageContext.request.contextPath}");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jsp/codeInspection/JspAbsolutePathInspection$AddDynamicPrefixFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jsp/codeInspection/JspAbsolutePathInspection$AddDynamicPrefixFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

