/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class EnterInScriptletHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            EnterInScriptletHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EnterInScriptletHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            EnterInScriptletHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterInScriptletHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterInScriptletHandler.$$$reportNull$$$0(4);
        }
        if (CodeInsightSettings.getInstance().INSERT_SCRIPTLET_END_ON_ENTER && EnterInScriptletHandler.isAfterUnmatchedScriptlet(editor, (Integer)caretOffset.get())) {
            editor.getDocument().insertString(((Integer)caretOffset.get()).intValue(), (CharSequence)"%>");
            originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isAfterUnmatchedScriptlet(Editor editor, int offset) {
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (!(offset >= 3 && chars.charAt(offset - 1) == '!' && chars.charAt(offset - 2) == '%' && chars.charAt(offset - 3) == '<' || offset >= 2 && chars.charAt(offset - 1) == '%' && chars.charAt(offset - 2) == '<')) {
            return false;
        }
        EditorHighlighter highlighter = editor.getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 2);
        if (iterator.getTokenType() != JspTokenType.JSP_SCRIPTLET_START && iterator.getTokenType() != JspTokenType.JSP_DECLARATION_START) {
            return false;
        }
        iterator = highlighter.createIterator(offset);
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == JspTokenType.JSP_SCRIPTLET_START || tokenType == JspTokenType.JSP_DECLARATION_START) {
                return true;
            }
            if (tokenType == JspTokenType.JSP_SCRIPTLET_END || tokenType == JspTokenType.JSP_DECLARATION_END) {
                return false;
            }
            iterator.advance();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/jsp/codeInsight/editorActions/EnterInScriptletHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

