/*
 * Decompiled with CFR 0.152.
 */
package org.gga.graph.search.dfs;

import java.util.Iterator;
import org.gga.graph.Edge;
import org.gga.graph.Graph;
import org.gga.graph.search.dfs.DfsVisitor;

public final class DepthFirstSearch {
    public static void depthFirstSearch(Graph graph, DfsVisitor visitor, short[] colorMap) {
        DepthFirstSearch.depthFirstSearch(graph, visitor, colorMap, 0);
    }

    public static void depthFirstSearch(Graph graph, DfsVisitor visitor, short[] colorMap, int firstVertex) {
        int v;
        if (graph.V() == 0) {
            return;
        }
        for (v = 0; v < graph.V(); ++v) {
            colorMap[v] = 2;
            visitor.initializeVertex(v, graph);
        }
        visitor.startVertex(firstVertex, graph);
        DepthFirstSearch._dfs(graph, visitor, colorMap, firstVertex);
        for (v = 0; v < graph.V(); ++v) {
            if (colorMap[v] != 2) continue;
            visitor.startVertex(v, graph);
            DepthFirstSearch._dfs(graph, visitor, colorMap, v);
        }
    }

    private static void _dfs(Graph graph, DfsVisitor visitor, short[] colorMap, int v) {
        colorMap[v] = 1;
        visitor.discoverVertex(v, graph);
        Iterator<Edge> i = graph.getEdges(v);
        while (i.hasNext()) {
            Edge e = i.next();
            int w = e.other(v);
            visitor.examineEdge(e, graph);
            if (colorMap[w] == 2) {
                visitor.treeEdge(e, graph);
                DepthFirstSearch._dfs(graph, visitor, colorMap, w);
                continue;
            }
            if (colorMap[w] == 1) {
                visitor.backEdge(e, graph);
                continue;
            }
            visitor.forwardOrCrossEdge(e, graph);
        }
        visitor.finishVertex(v, graph);
        colorMap[v] = 0;
    }

    public static void depthFirstSearch(Graph graph, DfsVisitor visitor) {
        DepthFirstSearch.depthFirstSearch(graph, visitor, new short[graph.V()]);
    }
}

