/*
 * Decompiled with CFR 0.152.
 */
package org.gga.graph.search.bfs;

import java.util.Arrays;
import java.util.Iterator;
import org.gga.graph.Edge;
import org.gga.graph.Graph;
import org.gga.graph.search.bfs.BfsVisitor;
import org.gga.graph.util.IntQueue;

public final class BreadthFirstSearch {
    public static void breadthFirstSearch(Graph g, BfsVisitor visitor, short[] colorMap, int firstVertex) {
        for (int i = 0; i < g.V(); ++i) {
            visitor.initializeVertex(i, g);
        }
        BreadthFirstSearch.bfs(g, visitor, colorMap, firstVertex);
    }

    public static void breadthFirstSearch(Graph g, BfsVisitor visitor, int firstVertex) {
        short[] colorMap = new short[g.V()];
        Arrays.fill(colorMap, (short)2);
        BreadthFirstSearch.breadthFirstSearch(g, visitor, colorMap, firstVertex);
    }

    private static void bfs(Graph g, BfsVisitor visitor, short[] colorMap, int firstVertex) {
        IntQueue q = new IntQueue();
        colorMap[firstVertex] = 1;
        visitor.discoverVertex(firstVertex, g);
        q.push(firstVertex);
        while (!q.isEmpty()) {
            int v = q.pop();
            visitor.examineVertex(v, g);
            Iterator<Edge> i = g.getEdges(v);
            while (i.hasNext()) {
                Edge e = i.next();
                visitor.examineEdge(e, g);
                int w = e.w();
                short c = colorMap[w];
                if (c == 2) {
                    visitor.treeEdge(e, g);
                    colorMap[w] = 1;
                    visitor.discoverVertex(w, g);
                    q.push(w);
                    continue;
                }
                visitor.nonTreeEdge(e, g);
                if (c == 1) {
                    visitor.greyTarget(e, g);
                    continue;
                }
                visitor.blackTarget(e, g);
            }
            colorMap[v] = 0;
            visitor.finishVertex(v, g);
        }
    }
}

