/*
 * Decompiled with CFR 0.152.
 */
package org.gga.graph.impl;

import org.gga.graph.Edge;
import org.gga.graph.Graph;
import org.gga.graph.impl.BiVertexMapImpl;
import org.gga.graph.impl.EdgeMapImpl;
import org.gga.graph.impl.GraphImpl;
import org.gga.graph.impl.SparseGraphImpl;
import org.gga.graph.maps.BiVertexMap;
import org.gga.graph.maps.DataGraph;
import org.gga.graph.maps.EdgeMap;

public class DataGraphImpl<N, E>
implements DataGraph<N, E> {
    private final Graph graph;
    private final BiVertexMap<N> vertices = new BiVertexMapImpl<N>();
    private final EdgeMap<E> edges = new EdgeMapImpl();

    public DataGraphImpl(int size, boolean isDirected, DataGraph.Implementation implementation) {
        this.graph = implementation == DataGraph.Implementation.SPARSE ? new SparseGraphImpl(size, isDirected) : new GraphImpl(size, isDirected);
    }

    public DataGraphImpl(int size, boolean isDirected) {
        this(size, isDirected, DataGraph.Implementation.SPARSE);
    }

    @Override
    public int V() {
        return this.graph.V();
    }

    @Override
    public boolean isDirected() {
        return this.graph.isDirected();
    }

    @Override
    public E edge(N n1, N n2) {
        int v1 = this.vertices.getVertex(n1);
        int v2 = this.vertices.getVertex(n2);
        if (v1 < 0 || v2 < 0) {
            return null;
        }
        Edge edge = this.graph.edge(v1, v2);
        return edge != null ? (E)this.edges.get(edge) : null;
    }

    @Override
    public E getEdge(Edge e) {
        return this.edges.get(e);
    }

    @Override
    public Edge insert(N n1, N n2, E e) {
        Edge edge = this.graph.insert(this.vertices.getVertex(n1), this.vertices.getVertex(n2));
        this.edges.put(edge, e);
        return edge;
    }

    @Override
    public void remove(Edge edge) {
        this.graph.remove(edge);
    }

    @Override
    public Graph getIntGraph() {
        return this.graph;
    }

    @Override
    public int getIndex(N data) {
        return this.vertices.getVertex(data);
    }

    @Override
    public N getNode(int v) {
        return (N)this.vertices.get(v);
    }

    @Override
    public void setNode(int v, N data) {
        this.vertices.put(v, data);
    }
}

