/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.DsmModelUtil;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.model.classes.DsmPsiNode;
import com.intellij.dsm.settings.DsmViewSettings;
import com.intellij.dsm.ui.BandPainter;
import com.intellij.dsm.ui.Cache;
import com.intellij.dsm.ui.DsmDataKeys;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmSelectionModel;
import com.intellij.dsm.ui.DsmSelectionModelImpl;
import com.intellij.dsm.ui.DsmTable;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableSpeedSearch;
import com.intellij.dsm.ui.DsmTableUtil;
import com.intellij.dsm.ui.IconCache;
import com.intellij.dsm.ui.NodeVisitor;
import com.intellij.dsm.ui.PaintCyclesVisitor;
import com.intellij.dsm.ui.PaintSelection0Visitor;
import com.intellij.dsm.ui.RowAnnotation;
import com.intellij.dsm.ui.RowAnnotationsUpdater;
import com.intellij.dsm.ui.RowHeaderView;
import com.intellij.dsm.ui.TableMouseHandler;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ScrollUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.gga.graph.Morph;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DsmTableImpl<N>
extends JComponent
implements DsmTable<N>,
Scrollable {
    final DsmModel<N> myModel;
    DataGraph<DsmTreeStructure.TreeNode<N>, Integer> myGraph;
    int myBoxSize = JBUIScale.scale((int)18);
    private final DsmViewSettings mySettings;
    final Set<DsmTreeStructure.TreeNode> myExpandedNodes = new HashSet<DsmTreeStructure.TreeNode>();
    Cache<N> myCache;
    volatile int myCycleCount = -2;
    boolean myGraphUpdateNeeded = true;
    final Map<DsmTreeStructure.TreeNode, RowAnnotation> myRowAnnotations = new HashMap<DsmTreeStructure.TreeNode, RowAnnotation>();
    final IconCache myIconCache = new IconCache();
    final DsmSelectionModelImpl<N> mySelectionModel = new DsmSelectionModelImpl(this);
    final TableMouseHandler<N> myMouseHandler = new TableMouseHandler(this);
    private final RowHeaderView<N> myRowHeaderView = new RowHeaderView(this);

    DsmTableImpl(DsmModel<N> model, DsmViewSettings settings) {
        this.myModel = model;
        this.mySettings = settings;
        this.setToolTipText("");
        this.expand(this.myModel.getTreeStructure().getRootNode());
        this.myModel.getTreeStructure().addTreeStructureListener(new DsmTreeStructure.TreeStructureListener(){

            @Override
            public void beforeTreeStructureChanged() {
            }

            @Override
            public void afterTreeStructureChanged() {
                DsmTableImpl.this.myExpandedNodes.clear();
                DsmTableImpl.this.getSelectionModel().clear();
                DsmTableImpl.this.myGraphUpdateNeeded = true;
                DsmTableImpl.this.expand(DsmTableImpl.this.myModel.getTreeStructure().getRootNode());
                DsmTableImpl.this.myCycleCount = -2;
                DsmTableImpl.this.update(true);
            }
        });
        this.getSelectionModel().addSelectionModelListener(new DsmSelectionModel.DsmSelectionModelListener(){

            @Override
            public void selectionChanged() {
                DsmTableImpl.this.myRowAnnotations.clear();
                DsmTableImpl.this.updateRowAnnotations();
                DsmTableImpl.this.update();
            }
        });
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.enableEvents(8L);
        this.setFocusable(true);
        new DsmTableSpeedSearch(this);
    }

    @Override
    public void scrollRowToVisible(DsmTreeStructure.TreeNode<N> row) {
        this.updateCache();
        this.scrollRectToVisible(this.myCache.rowHeaderBounds.get(row));
    }

    @Override
    public void scrollCellToVisible(DsmTreeStructure.TreeNode<N> row, DsmTreeStructure.TreeNode<N> col) {
        SwingUtilities.invokeLater(() -> {
            Rectangle r = this.getCellRectangle(row, col);
            assert (r != null);
            ScrollUtil.center((JComponent)this, (Rectangle)r);
        });
    }

    @Override
    public int getRowIndex(DsmTreeStructure.TreeNode<N> row) {
        this.updateCache();
        return this.myCache.rowIndices.get(row);
    }

    @Override
    public DsmTreeStructure.TreeNode<N> getRowByIndex(int index) {
        this.updateCache();
        List rows = this.myCache.myRows;
        if (index < 0 || index >= rows.size()) {
            return null;
        }
        return rows.get(index);
    }

    @Override
    public Dimension getPreferredSize() {
        this.updateCache();
        return new Dimension(this.myCache.myTableSize + 1, this.myCache.myTableSize + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        this.updateCache();
        Graphics2D g = (Graphics2D)graphics;
        Rectangle clipBounds = g.getClipBounds();
        AffineTransform transform = g.getTransform();
        try {
            this.paint(g, clipBounds);
        }
        finally {
            g.setTransform(transform);
            g.setClip(clipBounds);
        }
    }

    private void paint(Graphics2D g, Rectangle clipBounds) {
        int modelSize = this.myCache.myRows.size();
        int boxWidth = modelSize * this.myBoxSize;
        int boxHeight = modelSize * this.myBoxSize;
        int minX = Math.max(0, clipBounds.x / this.myBoxSize - 1);
        int maxX = Math.min(modelSize, (clipBounds.x + clipBounds.width) / this.myBoxSize + 1);
        int minY = Math.max(0, clipBounds.y / this.myBoxSize - 1);
        int maxY = Math.min(modelSize, (clipBounds.y + clipBounds.height) / this.myBoxSize + 1);
        this.getSelectionModel().acceptSelection(new PaintSelection0Visitor(this, g));
        this.paintDeps(g, minX, maxX, minY, maxY);
        g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
        g.drawLine(0, 0, boxWidth, 0);
        g.drawLine(0, boxHeight, boxWidth, boxHeight);
        g.drawLine(boxWidth, 0, boxWidth, boxHeight);
        if (!this.isSmall()) {
            this.paintGrid(g, minX, maxX, minY, maxY);
            this.acceptNodes(new BandPainter(this, g));
        }
        if (this.mySettings.isGroupCycles()) {
            this.acceptNodes(new PaintCyclesVisitor(this, g), true);
        }
    }

    @Override
    public int getCycleCount() {
        return this.myCycleCount;
    }

    @Override
    public boolean isDisplayCycles() {
        return this.mySettings.isGroupCycles();
    }

    @Override
    public void setDisplayCycles(boolean b) {
        this.mySettings.setGroupCycles(b);
        this.update(true);
    }

    @Override
    public DsmSelectionModel<N> getSelectionModel() {
        return this.mySelectionModel;
    }

    @Override
    public void setUseGradient(boolean state) {
        this.mySettings.setUseGradient(state);
        this.update();
    }

    @Override
    public boolean isUseGradient() {
        return this.mySettings.isUseGradient();
    }

    public boolean isSmall() {
        return this.myBoxSize < 8;
    }

    public boolean isSuperSmall() {
        return this.myBoxSize < 3;
    }

    @Override
    public DsmViewSettings getSettings() {
        return this.mySettings;
    }

    DsmTreeStructure.TreeNode<N> getVisibleNodeAncestor(@NotNull DsmTreeStructure.TreeNode<N> node) {
        if (node == null) {
            DsmTableImpl.$$$reportNull$$$0(0);
        }
        while (!this.myCache.rowHeaderBounds.containsKey(node)) {
            DsmTreeStructure.TreeNode<N> parent = node.getParent();
            assert (parent != null) : "root is not visible: " + node;
            node = parent;
        }
        return node;
    }

    void updateCache() {
        if (this.myCache == null || this.myGraphUpdateNeeded) {
            this.updateFont();
            this.myCache = new Cache(this);
        }
        if (this.myGraphUpdateNeeded) {
            this.rebuildGraph();
            this.updateRowAnnotations();
        }
        if (this.myCycleCount == -2 && Registry.is((String)"dsm.show.cycle.count.in.tooltip")) {
            this.myCycleCount = -1;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                long timeStamp = System.currentTimeMillis();
                DsmTreeStructure.TreeNode<N> node = this.myModel.getTreeStructure().getRootNode();
                this.myCycleCount = DsmModelUtil.countCycles(node);
                Logger.getInstance(Cache.class).info("Counted cycles in " + (double)(System.currentTimeMillis() - timeStamp) / 1000.0 + " seconds");
            });
        }
    }

    void acceptNodes(NodeVisitor<N> v) {
        this.acceptNodes(v, false);
    }

    private void acceptNodes(NodeVisitor<N> v, boolean acceptRoot) {
        DsmTreeStructure.TreeNode<N> rootNode = this.myModel.getTreeStructure().getRootNode();
        int y = 0;
        DsmTreeStructure.TreeNode<N>[] children = rootNode.getChildren();
        for (int i = 0; i < children.length; ++i) {
            DsmTreeStructure.TreeNode<N> node = children[i];
            y = this.acceptNode(node, 0, y, v, i == 0, i == children.length - 1);
        }
        if (acceptRoot) {
            v.visitExpanded(rootNode, 0, 0, this.myBoxSize * this.myCache.myRows.size(), true);
        }
    }

    void processMouseWheelEventFromScrollPane(MouseWheelEvent e) {
        if (EditorUtil.isChangeFontSize((MouseWheelEvent)e)) {
            this.zoom(e.getWheelRotation() < 0 ? this.myBoxSize + 1 : this.myBoxSize - 1, e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public boolean canZoomIn() {
        return this.myBoxSize < 2 * JBUIScale.scale((int)18);
    }

    @Override
    public void zoomIn() {
        this.zoom(this.myBoxSize + 1, -1, -1);
    }

    @Override
    public boolean canZoomOut() {
        return this.myBoxSize > 1;
    }

    @Override
    public void zoomOut() {
        this.zoom(this.myBoxSize - 1, -1, -1);
    }

    private void zoom(int newBoxSize, int x, int y) {
        if (newBoxSize < 1 || newBoxSize > this.myBoxSize && newBoxSize > 2 * JBUIScale.scale((int)18)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Point pos = viewport.getViewPosition();
        Dimension extentSize = viewport.getExtentSize();
        double zoom = (double)newBoxSize / (double)this.myBoxSize;
        if (x < 0 || y < 0) {
            x = extentSize.width / 2;
            y = extentSize.height / 2;
        }
        pos.x = (int)((double)pos.x * zoom) + (int)((double)x * (zoom - 1.0));
        pos.y = (int)((double)pos.y * zoom) + (int)((double)y * (zoom - 1.0));
        this.myBoxSize = newBoxSize;
        viewport.setViewPosition(pos);
        this.update(true);
    }

    void update() {
        this.update(false);
    }

    void update(boolean rebuildCache) {
        if (rebuildCache || this.myGraphUpdateNeeded) {
            this.myCache = null;
        }
        this.revalidate();
        this.repaint();
        this.myRowHeaderView.revalidate();
        this.myRowHeaderView.repaint();
    }

    private void updateFont() {
        Font f = this.getFont();
        if (f != null) {
            float size = (float)JBUIScale.scale((int)12) * ((float)this.myBoxSize / (float)JBUIScale.scale((int)18));
            Font newFont = f.deriveFont(size);
            this.setFont(newFont);
            this.myRowHeaderView.setFont(newFont);
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DsmTableImpl.$$$reportNull$$$0(1);
        }
        if (DsmDataKeys.SELECTION.is(dataId)) {
            return this.getSelectionModel().getSelection();
        }
        if (DsmDataKeys.DSM_MODEL.is(dataId)) {
            return this.myModel;
        }
        if (DsmDataKeys.DSM_TABLE.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
            Collection<DsmSelection<N>> selections = this.getSelectionModel().getSelection();
            if (selections.size() != 1) {
                return null;
            }
            DsmSelection<N> s = selections.iterator().next();
            if (s.type != DsmSelection.Type.ROW) {
                return null;
            }
            Set nodes = s.node1;
            if (nodes.size() > 1) {
                return null;
            }
            DsmTreeStructure.TreeNode node = s.node1.iterator().next();
            if (!node.isLeaf()) {
                return null;
            }
            return this.myCache.rowHeaderBounds.get(node);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            Collection<DsmSelection<N>> selections = this.getSelectionModel().getSelection();
            if (selections.size() != 1) {
                return null;
            }
            DsmSelection<N> s = selections.iterator().next();
            if (s.type != DsmSelection.Type.ROW) {
                return null;
            }
            Set nodes = s.node1;
            if (nodes.size() > 1) {
                return null;
            }
            DsmTreeStructure.TreeNode node = s.node1.iterator().next();
            if (!node.isLeaf()) {
                return null;
            }
            Object leafData = node.getLeafData();
            if (!(leafData instanceof DsmPsiNode)) {
                return null;
            }
            DsmPsiNode psiNode = (DsmPsiNode)leafData;
            return psiNode.getElement();
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            Collection<DsmSelection<N>> selections = this.getSelectionModel().getSelection();
            SmartList elements = new SmartList();
            for (DsmSelection<N> selection : selections) {
                if (selection.type != DsmSelection.Type.ROW) {
                    return null;
                }
                for (DsmTreeStructure.TreeNode node : selection.node1) {
                    DsmPsiNode psiNode;
                    PsiElement element;
                    Object leafData;
                    if (!node.isLeaf() || !((leafData = node.getLeafData()) instanceof DsmPsiNode) || (element = (psiNode = (DsmPsiNode)leafData).getElement()) == null) continue;
                    elements.add(element);
                }
            }
            return elements.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.toolWindows.dsm";
        }
        return null;
    }

    public Component getRowHeaderView() {
        return this.myRowHeaderView;
    }

    Color getHeaderBg(DsmTreeStructure.TreeNode<N> node) {
        if (this.getSelectionModel().isSelected(node)) {
            Set<DsmTreeStructure.TreeNode<N>> nodeSet = Collections.singleton(node);
            for (DsmSelection<N> selection : this.getSelectionModel().getSelection()) {
                if (selection.type != DsmSelection.Type.CELL) continue;
                if (nodeSet.equals(selection.node1)) {
                    return DsmTableConstants.COLOR_BCK_DEP;
                }
                if (!nodeSet.equals(selection.node2)) continue;
                return DsmTableConstants.COLOR_FWD_DEP;
            }
            return UIUtil.getTreeSelectionBackground((boolean)this.isFocusOwner());
        }
        if (node.isLeaf()) {
            return DsmTableConstants.COLOR_CLASS_ROW;
        }
        return DsmTableConstants.COLOR_PACKAGE_ROW;
    }

    Color getHeaderFg(DsmTreeStructure.TreeNode<N> node) {
        if (this.getSelectionModel().isSelected(node) && this.isFocusOwner()) {
            return UIUtil.getTreeSelectionForeground();
        }
        return this.getForeground();
    }

    int acceptNode(DsmTreeStructure.TreeNode<N> node, int x, int y, NodeVisitor<N> visitor, boolean isFirst, boolean isLast) {
        if (node.isLeaf()) {
            visitor.visitLeaf(node, x, y, this.myBoxSize, isFirst, isLast);
            return y + this.myBoxSize;
        }
        if (this.isExpanded(node)) {
            int x1 = x + this.myBoxSize;
            int y1 = y;
            DsmTreeStructure.TreeNode<N>[] nodes = node.getChildren();
            for (int i = 0; i < nodes.length; ++i) {
                DsmTreeStructure.TreeNode<N> child = nodes[i];
                if (!this.mySettings.isGroupCycles() && child.getCycle() != null) {
                    DsmTreeStructure.TreeNode<N>[] grandChildren = child.getChildren();
                    for (int j = 0; j < grandChildren.length; ++j) {
                        DsmTreeStructure.TreeNode<N> grandChild = grandChildren[j];
                        y1 = this.acceptNode(grandChild, x1, y1, visitor, i == 0 && j == 0, i == nodes.length - 1 && j == grandChildren.length - 1);
                    }
                    continue;
                }
                y1 = this.acceptNode(child, x1, y1, visitor, i == 0, i == nodes.length - 1);
            }
            visitor.visitExpanded(node, x, y, y1 - y, isLast);
            return y1;
        }
        visitor.visitCollapsed(node, x, y, this.myBoxSize, isFirst, isLast);
        return y + this.myBoxSize;
    }

    private void paintDeps(Graphics2D g, int minX, int maxX, int minY, int maxY) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                this.paintDep(g, i, j);
            }
        }
    }

    private void paintDep(Graphics2D g, int i, int j) {
        int x1;
        Color color;
        String s = null;
        int x = this.myBoxSize * i;
        int y = this.myBoxSize * j;
        int sz = this.myBoxSize - 3;
        if (i == j) {
            color = null;
            s = null;
            g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
            if (!this.isSmall()) {
                x1 = x + sz / 2;
                g.drawRect(x1, y + this.myBoxSize / 2, 3, 1);
            } else {
                g.fillRect(x, y, this.myBoxSize, this.myBoxSize);
            }
        } else {
            int d;
            Integer e = this.myGraph.edge(this.myCache.myRows.get(i), this.myCache.myRows.get(j));
            int n = d = e != null ? e : 0;
            if (d == 0) {
                color = null;
            } else {
                color = this.getDependencyColor(i, j, d);
                s = String.valueOf(d);
            }
        }
        x1 = x + 2;
        int y1 = y + 2;
        if (color != null) {
            g.setPaint(color);
            if (!this.isSmall()) {
                g.fillRect(x1, y1, sz, sz);
            } else {
                g.fillRect(x, y, this.myBoxSize, this.myBoxSize);
            }
        }
        if (s != null && !this.isSmall()) {
            boolean periods;
            g.setPaint(DsmTableConstants.COLOR_CELL_FONT);
            Font font = g.getFont();
            boolean bl = periods = s.length() > 2;
            if (periods) {
                s = "...";
                g.setFont(font.deriveFont(1));
            }
            Rectangle2D stringBounds = font.getStringBounds(s, g.getFontRenderContext());
            UISettings.setupAntialiasing((Graphics)g);
            g.drawString(s, x1 + Math.max(0, sz - (int)stringBounds.getWidth()) / 2, y + (int)stringBounds.getHeight());
            if (periods) {
                g.setFont(font);
            }
        }
    }

    private Color getDependencyColor(int from, int to, int d) {
        Color c = DsmTableConstants.COLOR_DEP;
        if (this.mySettings.isGroupCycles() && this.myGraph.edge(this.myCache.myRows.get(to), this.myCache.myRows.get(from)) != null) {
            c = DsmTableConstants.COLOR_CYCLE;
        }
        if (!this.mySettings.isUseGradient()) {
            return c;
        }
        return ColorUtil.toAlpha((Color)c, (int)DsmTableUtil.calculateAlpha(d));
    }

    private void paintGrid(Graphics2D g, int minX, int maxX, int minY, int maxY) {
        int i;
        g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
        for (i = Math.max(minX, 1); i < Math.min(maxX, this.myCache.myRows.size()); ++i) {
            int x = this.myBoxSize * i;
            g.drawLine(x, minY * this.myBoxSize + 1, x, maxY * this.myBoxSize - 1);
        }
        for (i = Math.max(minY, 1); i < Math.min(maxY, this.myCache.myRows.size()); ++i) {
            int y = this.myBoxSize * i;
            g.drawLine(minX * this.myBoxSize, y, maxX * this.myBoxSize - 1, y);
        }
    }

    @Nullable
    private Rectangle getCellRectangle(DsmTreeStructure.TreeNode row, DsmTreeStructure.TreeNode col) {
        this.updateCache();
        Rectangle r1 = this.myCache.rowHeaderBounds.get(row);
        Rectangle r2 = this.myCache.rowHeaderBounds.get(col);
        if (r1 == null || r2 == null) {
            return null;
        }
        return new Rectangle(r2.y, r1.y, r2.height, r1.height);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this, true));
        }
        this.updateCache();
        this.myMouseHandler.processMouseEvent(e);
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.updateCache();
        this.myMouseHandler.processMouseMotionEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.getKeyCode() == 27) {
            this.getSelectionModel().clear();
        }
    }

    void updateRowAnnotations() {
        new RowAnnotationsUpdater(this).updateRowAnnotations();
    }

    boolean isExpanded(DsmTreeStructure.TreeNode node) {
        return this.myExpandedNodes.contains(node);
    }

    void expand(DsmTreeStructure.TreeNode node) {
        this.myGraphUpdateNeeded = true;
        this._expand(node);
    }

    private void _expand(DsmTreeStructure.TreeNode node) {
        this.myExpandedNodes.add(node);
        for (DsmTreeStructure.TreeNode child : node.getChildren()) {
            if (!child.isAutoExpand()) continue;
            this._expand(child);
        }
    }

    private void rebuildGraph() {
        this.myGraphUpdateNeeded = false;
        this.updateCache();
        int[] verticesMap = new int[this.myModel.getGraph().V()];
        for (int i = 0; i < this.myCache.myRows.size(); ++i) {
            DsmTreeStructure.TreeNode row = this.myCache.myRows.get(i);
            DsmModelUtil.fillLeafMap(row, i, verticesMap);
        }
        DataGraph<N, Integer> g = this.myModel.getGraph();
        this.myGraph = Morph.morph(g, n -> this.myCache.myRows.get(verticesMap[g.getIndex(n)]), l -> l.stream().mapToInt(Integer::intValue).sum());
    }

    void collapse(DsmTreeStructure.TreeNode node) {
        this.myGraphUpdateNeeded = true;
        this._collapse(node);
    }

    private void _collapse(DsmTreeStructure.TreeNode node) {
        DsmTreeStructure.TreeNode<N>[] nodes;
        if (!this.myExpandedNodes.remove(node)) {
            return;
        }
        for (DsmTreeStructure.TreeNode child : nodes = node.getChildren()) {
            if (child.isLeaf()) continue;
            this._collapse(child);
        }
    }

    @Nullable
    DsmTreeStructure.TreeNode<N> row(int y) {
        int rowNumber = y / this.myBoxSize;
        if (rowNumber < this.myCache.myRows.size() && rowNumber >= 0) {
            return this.myCache.myRows.get(rowNumber);
        }
        return null;
    }

    @Nullable
    DsmTreeStructure.TreeNode<N> col(int x) {
        int rowNumber = x / this.myBoxSize;
        if (rowNumber < this.myCache.myRows.size() && rowNumber >= 0) {
            return this.myCache.myRows.get(rowNumber);
        }
        return null;
    }

    @Override
    @Nullable
    public String getToolTipText(MouseEvent e) {
        this.updateCache();
        DsmTreeStructure.TreeNode<N> row = this.row(e.getY());
        DsmTreeStructure.TreeNode<N> col = this.col(e.getX());
        if (row == null || col == null) {
            return null;
        }
        Integer dep = this.myGraph.edge(col, row);
        if (dep == null || dep == 0) {
            return null;
        }
        String sFrom = col.getFullName();
        String sTo = row.getFullName();
        return StringUtil.escapeXmlEntities((String)(sFrom + " -> " + sTo + " (" + dep + ")"));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public DsmModel<N> getModel() {
        return this.myModel;
    }

    @Override
    public DataGraph<DsmTreeStructure.TreeNode<N>, Integer> getGraph() {
        return this.myGraph;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.myBoxSize;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (orientation == 1 ? visibleRect.height : visibleRect.width) - this.myBoxSize;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dsm/ui/DsmTableImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVisibleNodeAncestor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

