/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.And;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.gga.graph.maps.DataGraph;

public class PackagesSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    @Override
    public List<Pair<Predicate<? super ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, Predicate<? super ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        ArrayList<Pair<Predicate<? super ClassNode>, TopToBottomTreeStructure.NodeData>> result = new ArrayList<Pair<Predicate<? super ClassNode>, TopToBottomTreeStructure.NodeData>>();
        if (parentData instanceof MyClassesData) {
            result.add(new Pair(memberFunction, null));
            return result;
        }
        HashSet<String> subPackages = new HashSet<String>();
        HashSet<ClassNode> classesInPackage = new HashSet<ClassNode>();
        String currentPackage = parentData instanceof MyNodeData ? ((MyNodeData)parentData).myPackageName : "";
        Object prefix = currentPackage.length() == 0 ? currentPackage : currentPackage + ".";
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode2 = dataGraph.getNode(i);
            if (!memberFunction.test(classNode2)) continue;
            String packageName = classNode2.getPackageName();
            if (packageName.startsWith((String)prefix)) {
                String subName = packageName.substring(((String)prefix).length());
                int idx = subName.indexOf(".");
                if (idx >= 0) {
                    subName = subName.substring(0, idx);
                }
                subPackages.add(subName);
                continue;
            }
            classesInPackage.add(classNode2);
        }
        if (!subPackages.isEmpty()) {
            Object[] names = ArrayUtilRt.toStringArray(subPackages);
            Arrays.sort(names);
            for (Object packageShortName : names) {
                String packageName = (String)prefix + (String)packageShortName;
                result.add((Pair<Predicate<? super ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(new And<ClassNode>(memberFunction, classNode -> {
                    String name = classNode.getPackageName();
                    return StringUtil.startsWithConcatenation((String)name, (String[])new String[]{packageName, "."}) || name.equals(packageName);
                }), (Object)new MyNodeData(packageName, (String)packageShortName)));
            }
        }
        if (!classesInPackage.isEmpty()) {
            result.add((Pair<Predicate<? super ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(classNode -> classesInPackage.contains(classNode), (Object)new MyClassesData(currentPackage)));
        }
        return result;
    }

    private static class MyClassesData
    extends TopToBottomTreeStructure.NodeData {
        MyClassesData(String packageName) {
            super("*", packageName + ".*", AllIcons.Nodes.Package);
        }
    }

    private static class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        private final String myPackageName;

        MyNodeData(String packageName, String name) {
            super(name, packageName, AllIcons.Nodes.Package);
            this.myPackageName = packageName;
        }
    }
}

